<?php

namespace InforItem;

/**
 * This class stands for filterAttributeListDT EnumType
 * @package Item_
 * @subpackage Enumerations
 */
class Item_FilterAttributeListDT
{
    /**
     * Constant for value 'ProductLine.description'
     * @return string 'ProductLine.description'
     */
    const VALUE_PRODUCT_LINE_DESCRIPTION = 'ProductLine.description';
    /**
     * Constant for value 'ProductLine.productLineCode'
     * @return string 'ProductLine.productLineCode'
     */
    const VALUE_PRODUCT_LINE_PRODUCT_LINE_CODE = 'ProductLine.productLineCode';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PRODUCT_LINE_DESCRIPTION
     * @uses self::VALUE_PRODUCT_LINE_PRODUCT_LINE_CODE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PRODUCT_LINE_DESCRIPTION,
            self::VALUE_PRODUCT_LINE_PRODUCT_LINE_CODE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
