<?php

namespace InforItem;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ControlArea StructType
 * @package Item_
 * @subpackage Structs
 */
class Item_ControlArea extends AbstractStructBase
{
    /**
     * The Selection
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \InforItem\Item_SelectionType
     */
    public $Selection;
    /**
     * The Filter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \InforItem\Item_FilterType
     */
    public $Filter;
    /**
     * The sortingExpression
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sortingExpression;
    /**
     * The languageID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $languageID;
    /**
     * The suppressDefaultLanguageBehavior
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $suppressDefaultLanguageBehavior;
    /**
     * The maxNumberOfObjects
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $maxNumberOfObjects;
    /**
     * The iteratorID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $iteratorID;
    /**
     * The iteratorFetchSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $iteratorFetchSize;
    /**
     * The createRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $createRef;
    /**
     * The referenceID
     * @var string
     */
    public $referenceID;
    /**
     * Constructor method for ControlArea
     * @uses Item_ControlArea::setSelection()
     * @uses Item_ControlArea::setFilter()
     * @uses Item_ControlArea::setSortingExpression()
     * @uses Item_ControlArea::setLanguageID()
     * @uses Item_ControlArea::setSuppressDefaultLanguageBehavior()
     * @uses Item_ControlArea::setMaxNumberOfObjects()
     * @uses Item_ControlArea::setIteratorID()
     * @uses Item_ControlArea::setIteratorFetchSize()
     * @uses Item_ControlArea::setCreateRef()
     * @uses Item_ControlArea::setReferenceID()
     * @param \InforItem\Item_SelectionType $selection
     * @param \InforItem\Item_FilterType $filter
     * @param string $sortingExpression
     * @param string[] $languageID
     * @param bool $suppressDefaultLanguageBehavior
     * @param int $maxNumberOfObjects
     * @param int $iteratorID
     * @param int $iteratorFetchSize
     * @param bool $createRef
     * @param string $referenceID
     */
    public function __construct(\InforItem\Item_SelectionType $selection = null, \InforItem\Item_FilterType $filter = null, $sortingExpression = null, array $languageID = array(), $suppressDefaultLanguageBehavior = null, $maxNumberOfObjects = null, $iteratorID = null, $iteratorFetchSize = null, $createRef = null, $referenceID = null)
    {
        $this
            ->setSelection($selection)
            ->setFilter($filter)
            ->setSortingExpression($sortingExpression)
            ->setLanguageID($languageID)
            ->setSuppressDefaultLanguageBehavior($suppressDefaultLanguageBehavior)
            ->setMaxNumberOfObjects($maxNumberOfObjects)
            ->setIteratorID($iteratorID)
            ->setIteratorFetchSize($iteratorFetchSize)
            ->setCreateRef($createRef)
            ->setReferenceID($referenceID);
    }
    /**
     * Get Selection value
     * @return \InforItem\Item_SelectionType|null
     */
    public function getSelection()
    {
        return $this->Selection;
    }
    /**
     * Set Selection value
     * @param \InforItem\Item_SelectionType $selection
     * @return \InforItem\Item_ControlArea
     */
    public function setSelection(\InforItem\Item_SelectionType $selection = null)
    {
        $this->Selection = $selection;
        return $this;
    }
    /**
     * Get Filter value
     * @return \InforItem\Item_FilterType|null
     */
    public function getFilter()
    {
        return $this->Filter;
    }
    /**
     * Set Filter value
     * @param \InforItem\Item_FilterType $filter
     * @return \InforItem\Item_ControlArea
     */
    public function setFilter(\InforItem\Item_FilterType $filter = null)
    {
        $this->Filter = $filter;
        return $this;
    }
    /**
     * Get sortingExpression value
     * @return string|null
     */
    public function getSortingExpression()
    {
        return $this->sortingExpression;
    }
    /**
     * Set sortingExpression value
     * @param string $sortingExpression
     * @return \InforItem\Item_ControlArea
     */
    public function setSortingExpression($sortingExpression = null)
    {
        // validation for constraint: string
        if (!is_null($sortingExpression) && !is_string($sortingExpression)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sortingExpression)), __LINE__);
        }
        $this->sortingExpression = $sortingExpression;
        return $this;
    }
    /**
     * Get languageID value
     * @return string[]|null
     */
    public function getLanguageID()
    {
        return $this->languageID;
    }
    /**
     * Set languageID value
     * @throws \InvalidArgumentException
     * @param string[] $languageID
     * @return \InforItem\Item_ControlArea
     */
    public function setLanguageID(array $languageID = array())
    {
        foreach ($languageID as $controlAreaLanguageIDItem) {
            // validation for constraint: itemType
            if (!is_string($controlAreaLanguageIDItem)) {
                throw new \InvalidArgumentException(sprintf('The languageID property can only contain items of language, "%s" given', is_object($controlAreaLanguageIDItem) ? get_class($controlAreaLanguageIDItem) : gettype($controlAreaLanguageIDItem)), __LINE__);
            }
        }
        $this->languageID = $languageID;
        return $this;
    }
    /**
     * Add item to languageID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \InforItem\Item_ControlArea
     */
    public function addToLanguageID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The languageID property can only contain items of language, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->languageID[] = $item;
        return $this;
    }
    /**
     * Get suppressDefaultLanguageBehavior value
     * @return bool|null
     */
    public function getSuppressDefaultLanguageBehavior()
    {
        return $this->suppressDefaultLanguageBehavior;
    }
    /**
     * Set suppressDefaultLanguageBehavior value
     * @param bool $suppressDefaultLanguageBehavior
     * @return \InforItem\Item_ControlArea
     */
    public function setSuppressDefaultLanguageBehavior($suppressDefaultLanguageBehavior = null)
    {
        // validation for constraint: boolean
        if (!is_null($suppressDefaultLanguageBehavior) && !is_bool($suppressDefaultLanguageBehavior)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($suppressDefaultLanguageBehavior)), __LINE__);
        }
        $this->suppressDefaultLanguageBehavior = $suppressDefaultLanguageBehavior;
        return $this;
    }
    /**
     * Get maxNumberOfObjects value
     * @return int|null
     */
    public function getMaxNumberOfObjects()
    {
        return $this->maxNumberOfObjects;
    }
    /**
     * Set maxNumberOfObjects value
     * @param int $maxNumberOfObjects
     * @return \InforItem\Item_ControlArea
     */
    public function setMaxNumberOfObjects($maxNumberOfObjects = null)
    {
        // validation for constraint: int
        if (!is_null($maxNumberOfObjects) && !is_numeric($maxNumberOfObjects)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxNumberOfObjects)), __LINE__);
        }
        $this->maxNumberOfObjects = $maxNumberOfObjects;
        return $this;
    }
    /**
     * Get iteratorID value
     * @return int|null
     */
    public function getIteratorID()
    {
        return $this->iteratorID;
    }
    /**
     * Set iteratorID value
     * @param int $iteratorID
     * @return \InforItem\Item_ControlArea
     */
    public function setIteratorID($iteratorID = null)
    {
        // validation for constraint: int
        if (!is_null($iteratorID) && !is_numeric($iteratorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iteratorID)), __LINE__);
        }
        $this->iteratorID = $iteratorID;
        return $this;
    }
    /**
     * Get iteratorFetchSize value
     * @return int|null
     */
    public function getIteratorFetchSize()
    {
        return $this->iteratorFetchSize;
    }
    /**
     * Set iteratorFetchSize value
     * @param int $iteratorFetchSize
     * @return \InforItem\Item_ControlArea
     */
    public function setIteratorFetchSize($iteratorFetchSize = null)
    {
        // validation for constraint: int
        if (!is_null($iteratorFetchSize) && !is_numeric($iteratorFetchSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iteratorFetchSize)), __LINE__);
        }
        $this->iteratorFetchSize = $iteratorFetchSize;
        return $this;
    }
    /**
     * Get createRef value
     * @return bool|null
     */
    public function getCreateRef()
    {
        return $this->createRef;
    }
    /**
     * Set createRef value
     * @param bool $createRef
     * @return \InforItem\Item_ControlArea
     */
    public function setCreateRef($createRef = null)
    {
        // validation for constraint: boolean
        if (!is_null($createRef) && !is_bool($createRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($createRef)), __LINE__);
        }
        $this->createRef = $createRef;
        return $this;
    }
    /**
     * Get referenceID value
     * @return string|null
     */
    public function getReferenceID()
    {
        return $this->referenceID;
    }
    /**
     * Set referenceID value
     * @param string $referenceID
     * @return \InforItem\Item_ControlArea
     */
    public function setReferenceID($referenceID = null)
    {
        // validation for constraint: string
        if (!is_null($referenceID) && !is_string($referenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceID)), __LINE__);
        }
        $this->referenceID = $referenceID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \InforItem\Item_ControlArea
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
