<?php

namespace InforItem;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ComparisonExpressionType StructType
 * @package Item_
 * @subpackage Structs
 */
class Item_ComparisonExpressionType extends AbstractStructBase
{
    /**
     * The comparisonOperator
     * @var string
     */
    public $comparisonOperator;
    /**
     * The attributeName
     * @var string
     */
    public $attributeName;
    /**
     * The emptyValue
     * @var \InforItem\Item_EmptyValueType
     */
    public $emptyValue;
    /**
     * The instanceValue
     * @var string
     */
    public $instanceValue;
    /**
     * Constructor method for ComparisonExpressionType
     * @uses Item_ComparisonExpressionType::setComparisonOperator()
     * @uses Item_ComparisonExpressionType::setAttributeName()
     * @uses Item_ComparisonExpressionType::setEmptyValue()
     * @uses Item_ComparisonExpressionType::setInstanceValue()
     * @param string $comparisonOperator
     * @param string $attributeName
     * @param \InforItem\Item_EmptyValueType $emptyValue
     * @param string $instanceValue
     */
    public function __construct($comparisonOperator = null, $attributeName = null, \InforItem\Item_EmptyValueType $emptyValue = null, $instanceValue = null)
    {
        $this
            ->setComparisonOperator($comparisonOperator)
            ->setAttributeName($attributeName)
            ->setEmptyValue($emptyValue)
            ->setInstanceValue($instanceValue);
    }
    /**
     * Get comparisonOperator value
     * @return string|null
     */
    public function getComparisonOperator()
    {
        return $this->comparisonOperator;
    }
    /**
     * Set comparisonOperator value
     * @uses \InforItem\Item_ComparisonOperator::valueIsValid()
     * @uses \InforItem\Item_ComparisonOperator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $comparisonOperator
     * @return \InforItem\Item_ComparisonExpressionType
     */
    public function setComparisonOperator($comparisonOperator = null)
    {
        // validation for constraint: enumeration
        if (!\InforItem\Item_ComparisonOperator::valueIsValid($comparisonOperator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $comparisonOperator, implode(', ', \InforItem\Item_ComparisonOperator::getValidValues())), __LINE__);
        }
        $this->comparisonOperator = $comparisonOperator;
        return $this;
    }
    /**
     * Get attributeName value
     * @return string|null
     */
    public function getAttributeName()
    {
        return $this->attributeName;
    }
    /**
     * Set attributeName value
     * @uses \InforItem\Item_FilterAttributeListDT::valueIsValid()
     * @uses \InforItem\Item_FilterAttributeListDT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $attributeName
     * @return \InforItem\Item_ComparisonExpressionType
     */
    public function setAttributeName($attributeName = null)
    {
        // validation for constraint: enumeration
        if (!\InforItem\Item_FilterAttributeListDT::valueIsValid($attributeName)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $attributeName, implode(', ', \InforItem\Item_FilterAttributeListDT::getValidValues())), __LINE__);
        }
        $this->attributeName = $attributeName;
        return $this;
    }
    /**
     * Get emptyValue value
     * @return \InforItem\Item_EmptyValueType|null
     */
    public function getEmptyValue()
    {
        return $this->emptyValue;
    }
    /**
     * Set emptyValue value
     * @param \InforItem\Item_EmptyValueType $emptyValue
     * @return \InforItem\Item_ComparisonExpressionType
     */
    public function setEmptyValue(\InforItem\Item_EmptyValueType $emptyValue = null)
    {
        $this->emptyValue = $emptyValue;
        return $this;
    }
    /**
     * Get instanceValue value
     * @return string|null
     */
    public function getInstanceValue()
    {
        return $this->instanceValue;
    }
    /**
     * Set instanceValue value
     * @param string $instanceValue
     * @return \InforItem\Item_ComparisonExpressionType
     */
    public function setInstanceValue($instanceValue = null)
    {
        // validation for constraint: string
        if (!is_null($instanceValue) && !is_string($instanceValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($instanceValue)), __LINE__);
        }
        $this->instanceValue = $instanceValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \InforItem\Item_ComparisonExpressionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
