<?php

namespace InforItem;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ActivationType StructType
 * @package Item_
 * @subpackage Structs
 */
class Item_ActivationType extends AbstractStructBase
{
    /**
     * The username
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $username;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The company
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $company;
    /**
     * Constructor method for ActivationType
     * @uses Item_ActivationType::setUsername()
     * @uses Item_ActivationType::setPassword()
     * @uses Item_ActivationType::setCompany()
     * @param string $username
     * @param string $password
     * @param int $company
     */
    public function __construct($username = null, $password = null, $company = null)
    {
        $this
            ->setUsername($username)
            ->setPassword($password)
            ->setCompany($company);
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \InforItem\Item_ActivationType
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \InforItem\Item_ActivationType
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get company value
     * @return int|null
     */
    public function getCompany()
    {
        return $this->company;
    }
    /**
     * Set company value
     * @param int $company
     * @return \InforItem\Item_ActivationType
     */
    public function setCompany($company = null)
    {
        // validation for constraint: int
        if (!is_null($company) && !is_numeric($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($company)), __LINE__);
        }
        $this->company = $company;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \InforItem\Item_ActivationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
