<?php

namespace InforItem;

/**
 * This class stands for actionType EnumType
 * @package Item_
 * @subpackage Enumerations
 */
class Item_ActionType
{
    /**
     * Constant for value 'create'
     * @return string 'create'
     */
    const VALUE_CREATE = 'create';
    /**
     * Constant for value 'createOrChange'
     * @return string 'createOrChange'
     */
    const VALUE_CREATE_OR_CHANGE = 'createOrChange';
    /**
     * Constant for value 'change'
     * @return string 'change'
     */
    const VALUE_CHANGE = 'change';
    /**
     * Constant for value 'delete'
     * @return string 'delete'
     */
    const VALUE_DELETE = 'delete';
    /**
     * Constant for value 'unchanged'
     * @return string 'unchanged'
     */
    const VALUE_UNCHANGED = 'unchanged';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CREATE
     * @uses self::VALUE_CREATE_OR_CHANGE
     * @uses self::VALUE_CHANGE
     * @uses self::VALUE_DELETE
     * @uses self::VALUE_UNCHANGED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CREATE,
            self::VALUE_CREATE_OR_CHANGE,
            self::VALUE_CHANGE,
            self::VALUE_DELETE,
            self::VALUE_UNCHANGED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
