<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProjectListByProjectName StructType
 * @subpackage Structs
 */
class GetProjectListByProjectName extends AbstractStructBase
{
    /**
     * The projectType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $projectType;
    /**
     * The allProjects
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $allProjects;
    /**
     * The topN
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $topN;
    /**
     * The key
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $key;
    /**
     * The token
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProjectListToken
     */
    public $token;
    /**
     * The projectName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $projectName;
    /**
     * Constructor method for GetProjectListByProjectName
     * @uses GetProjectListByProjectName::setProjectType()
     * @uses GetProjectListByProjectName::setAllProjects()
     * @uses GetProjectListByProjectName::setTopN()
     * @uses GetProjectListByProjectName::setKey()
     * @uses GetProjectListByProjectName::setToken()
     * @uses GetProjectListByProjectName::setProjectName()
     * @param string $projectType
     * @param bool $allProjects
     * @param int $topN
     * @param string $key
     * @param \StructType\ProjectListToken $token
     * @param string $projectName
     */
    public function __construct($projectType = null, $allProjects = null, $topN = null, $key = null, \StructType\ProjectListToken $token = null, $projectName = null)
    {
        $this
            ->setProjectType($projectType)
            ->setAllProjects($allProjects)
            ->setTopN($topN)
            ->setKey($key)
            ->setToken($token)
            ->setProjectName($projectName);
    }
    /**
     * Get projectType value
     * @return string
     */
    public function getProjectType()
    {
        return $this->projectType;
    }
    /**
     * Set projectType value
     * @uses \EnumType\ProjectType::valueIsValid()
     * @uses \EnumType\ProjectType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $projectType
     * @return \StructType\GetProjectListByProjectName
     */
    public function setProjectType($projectType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProjectType::valueIsValid($projectType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $projectType, implode(', ', \EnumType\ProjectType::getValidValues())), __LINE__);
        }
        $this->projectType = $projectType;
        return $this;
    }
    /**
     * Get allProjects value
     * @return bool
     */
    public function getAllProjects()
    {
        return $this->allProjects;
    }
    /**
     * Set allProjects value
     * @param bool $allProjects
     * @return \StructType\GetProjectListByProjectName
     */
    public function setAllProjects($allProjects = null)
    {
        // validation for constraint: boolean
        if (!is_null($allProjects) && !is_bool($allProjects)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allProjects)), __LINE__);
        }
        $this->allProjects = $allProjects;
        return $this;
    }
    /**
     * Get topN value
     * @return int
     */
    public function getTopN()
    {
        return $this->topN;
    }
    /**
     * Set topN value
     * @param int $topN
     * @return \StructType\GetProjectListByProjectName
     */
    public function setTopN($topN = null)
    {
        // validation for constraint: int
        if (!is_null($topN) && !is_numeric($topN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($topN)), __LINE__);
        }
        $this->topN = $topN;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\GetProjectListByProjectName
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get token value
     * @return \StructType\ProjectListToken|null
     */
    public function getToken()
    {
        return $this->token;
    }
    /**
     * Set token value
     * @param \StructType\ProjectListToken $token
     * @return \StructType\GetProjectListByProjectName
     */
    public function setToken(\StructType\ProjectListToken $token = null)
    {
        $this->token = $token;
        return $this;
    }
    /**
     * Get projectName value
     * @return string|null
     */
    public function getProjectName()
    {
        return $this->projectName;
    }
    /**
     * Set projectName value
     * @param string $projectName
     * @return \StructType\GetProjectListByProjectName
     */
    public function setProjectName($projectName = null)
    {
        // validation for constraint: string
        if (!is_null($projectName) && !is_string($projectName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectName)), __LINE__);
        }
        $this->projectName = $projectName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetProjectListByProjectName
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
