<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetDatabaseLastCompiled
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDatabaseLastCompiled $parameters
     * @return \StructType\GetDatabaseLastCompiledResponse|bool
     */
    public function GetDatabaseLastCompiled(\StructType\GetDatabaseLastCompiled $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDatabaseLastCompiled($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProjectList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProjectList $parameters
     * @return \StructType\GetProjectListResponse|bool
     */
    public function GetProjectList(\StructType\GetProjectList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProjectList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProjectListByProjectName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProjectListByProjectName $parameters
     * @return \StructType\GetProjectListByProjectNameResponse|bool
     */
    public function GetProjectListByProjectName(\StructType\GetProjectListByProjectName $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProjectListByProjectName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProjectListByCreator
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProjectListByCreator $parameters
     * @return \StructType\GetProjectListByCreatorResponse|bool
     */
    public function GetProjectListByCreator(\StructType\GetProjectListByCreator $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProjectListByCreator($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProjectListByKeywords
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProjectListByKeywords $parameters
     * @return \StructType\GetProjectListByKeywordsResponse|bool
     */
    public function GetProjectListByKeywords(\StructType\GetProjectListByKeywords $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProjectListByKeywords($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProjectListByCreatedDate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProjectListByCreatedDate $parameters
     * @return \StructType\GetProjectListByCreatedDateResponse|bool
     */
    public function GetProjectListByCreatedDate(\StructType\GetProjectListByCreatedDate $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProjectListByCreatedDate($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCustomProjectInfoField
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomProjectInfoField $parameters
     * @return \StructType\GetCustomProjectInfoFieldResponse|bool
     */
    public function GetCustomProjectInfoField(\StructType\GetCustomProjectInfoField $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCustomProjectInfoField($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProjectInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProjectInfo $parameters
     * @return \StructType\GetProjectInfoResponse|bool
     */
    public function GetProjectInfo(\StructType\GetProjectInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProjectInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetQuestionnaire
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetQuestionnaire $parameters
     * @return \StructType\GetQuestionnaireResponse|bool
     */
    public function GetQuestionnaire(\StructType\GetQuestionnaire $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetQuestionnaire($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFilteredQuestionnaire
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFilteredQuestionnaire $parameters
     * @return \StructType\GetFilteredQuestionnaireResponse|bool
     */
    public function GetFilteredQuestionnaire(\StructType\GetFilteredQuestionnaire $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFilteredQuestionnaire($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPredefinedLists
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPredefinedLists $parameters
     * @return \StructType\GetPredefinedListsResponse|bool
     */
    public function GetPredefinedLists(\StructType\GetPredefinedLists $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPredefinedLists($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPredefinedList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPredefinedList $parameters
     * @return \StructType\GetPredefinedListResponse|bool
     */
    public function GetPredefinedList(\StructType\GetPredefinedList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPredefinedList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetQuotas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetQuotas $parameters
     * @return \StructType\GetQuotasResponse|bool
     */
    public function GetQuotas(\StructType\GetQuotas $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetQuotas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetQuota
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetQuota $parameters
     * @return \StructType\GetQuotaResponse|bool
     */
    public function GetQuota(\StructType\GetQuota $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetQuota($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFormByName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFormByName $parameters
     * @return \StructType\GetFormByNameResponse|bool
     */
    public function GetFormByName(\StructType\GetFormByName $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFormByName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetForm
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetForm $parameters
     * @return \StructType\GetFormResponse|bool
     */
    public function GetForm(\StructType\GetForm $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetForm($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNode $parameters
     * @return \StructType\GetNodeResponse|bool
     */
    public function GetNode(\StructType\GetNode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetNode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetNodes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetNodes $parameters
     * @return \StructType\GetNodesResponse|bool
     */
    public function GetNodes(\StructType\GetNodes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetNodes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFormsInLoop
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFormsInLoop $parameters
     * @return \StructType\GetFormsInLoopResponse|bool
     */
    public function GetFormsInLoop(\StructType\GetFormsInLoop $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFormsInLoop($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLoopStructure
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLoopStructure $parameters
     * @return \StructType\GetLoopStructureResponse|bool
     */
    public function GetLoopStructure(\StructType\GetLoopStructure $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetLoopStructure($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetConditionBranch
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetConditionBranch $parameters
     * @return \StructType\GetConditionBranchResponse|bool
     */
    public function GetConditionBranch(\StructType\GetConditionBranch $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetConditionBranch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRouting
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRouting $parameters
     * @return \StructType\GetRoutingResponse|bool
     */
    public function GetRouting(\StructType\GetRouting $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRouting($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSurveyStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSurveyStatus $parameters
     * @return \StructType\GetSurveyStatusResponse|bool
     */
    public function GetSurveyStatus(\StructType\GetSurveyStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSurveyStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetExternalAnswers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetExternalAnswers $parameters
     * @return \StructType\GetExternalAnswersResponse|bool
     */
    public function GetExternalAnswers(\StructType\GetExternalAnswers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetExternalAnswers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBenchmarkProjectIds
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBenchmarkProjectIds $parameters
     * @return \StructType\GetBenchmarkProjectIdsResponse|bool
     */
    public function GetBenchmarkProjectIds(\StructType\GetBenchmarkProjectIds $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetBenchmarkProjectIds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProjectEmailObjects
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProjectEmailObjects $parameters
     * @return \StructType\GetProjectEmailObjectsResponse|bool
     */
    public function GetProjectEmailObjects(\StructType\GetProjectEmailObjects $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetProjectEmailObjects($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetBenchmarkProjectIdsResponse|\StructType\GetConditionBranchResponse|\StructType\GetCustomProjectInfoFieldResponse|\StructType\GetDatabaseLastCompiledResponse|\StructType\GetExternalAnswersResponse|\StructType\GetFilteredQuestionnaireResponse|\StructType\GetFormByNameResponse|\StructType\GetFormResponse|\StructType\GetFormsInLoopResponse|\StructType\GetLoopStructureResponse|\StructType\GetNodeResponse|\StructType\GetNodesResponse|\StructType\GetPredefinedListResponse|\StructType\GetPredefinedListsResponse|\StructType\GetProjectEmailObjectsResponse|\StructType\GetProjectInfoResponse|\StructType\GetProjectListByCreatedDateResponse|\StructType\GetProjectListByCreatorResponse|\StructType\GetProjectListByKeywordsResponse|\StructType\GetProjectListByProjectNameResponse|\StructType\GetProjectListResponse|\StructType\GetQuestionnaireResponse|\StructType\GetQuotaResponse|\StructType\GetQuotasResponse|\StructType\GetRoutingResponse|\StructType\GetSurveyStatusResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
