<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Export ServiceType
 * @subpackage Services
 */
class Export extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ExportSurvey
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExportSurvey $parameters
     * @return \StructType\ExportSurveyResponse|bool
     */
    public function ExportSurvey(\StructType\ExportSurvey $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExportSurvey($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExportSurveyLayout
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExportSurveyLayout $parameters
     * @return \StructType\ExportSurveyLayoutResponse|bool
     */
    public function ExportSurveyLayout(\StructType\ExportSurveyLayout $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExportSurveyLayout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExportSurveyWithHTMLRemoved
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExportSurveyWithHTMLRemoved $parameters
     * @return \StructType\ExportSurveyWithHTMLRemovedResponse|bool
     */
    public function ExportSurveyWithHTMLRemoved(\StructType\ExportSurveyWithHTMLRemoved $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExportSurveyWithHTMLRemoved($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExportTranslation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExportTranslation $parameters
     * @return \StructType\ExportTranslationResponse|bool
     */
    public function ExportTranslation(\StructType\ExportTranslation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExportTranslation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ExportSurveyLayoutResponse|\StructType\ExportSurveyResponse|\StructType\ExportSurveyWithHTMLRemovedResponse|\StructType\ExportTranslationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
