<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://reporting.moh.gov.ge/Reporting/Services/HmisServiceWcf.svc?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://reporting.moh.gov.ge/Reporting/Services/HmisServiceWcf.svc?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Login ServiceType
 */
$login = new \ServiceType\Login($options);
/**
 * Sample call for Login operation/method
 */
if ($login->Login(new \StructType\Login()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetAllSchemas operation/method
 */
if ($get->GetAllSchemas(new \StructType\GetAllSchemas()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFormSchema operation/method
 */
if ($get->GetFormSchema(new \StructType\GetFormSchema()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllStatuses operation/method
 */
if ($get->GetAllStatuses(new \StructType\GetAllStatuses()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRegionDistricts operation/method
 */
if ($get->GetRegionDistricts(new \StructType\GetRegionDistricts()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFormData operation/method
 */
if ($get->GetFormData(new \StructType\GetFormData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRowData operation/method
 */
if ($get->GetRowData(new \StructType\GetRowData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetGridData operation/method
 */
if ($get->GetGridData(new \StructType\GetGridData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for AddFormGridData operation/method
 */
if ($add->AddFormGridData(new \StructType\AddFormGridData()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddRowData operation/method
 */
if ($add->AddRowData(new \StructType\AddRowData()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddGridData operation/method
 */
if ($add->AddGridData(new \StructType\AddGridData()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Fill ServiceType
 */
$fill = new \ServiceType\Fill($options);
/**
 * Sample call for FillFormData operation/method
 */
if ($fill->FillFormData(new \StructType\FillFormData()) !== false) {
    print_r($fill->getResult());
} else {
    print_r($fill->getLastError());
}
/**
 * Samples for Clear ServiceType
 */
$clear = new \ServiceType\Clear($options);
/**
 * Sample call for ClearFormData operation/method
 */
if ($clear->ClearFormData(new \StructType\ClearFormData()) !== false) {
    print_r($clear->getResult());
} else {
    print_r($clear->getLastError());
}
/**
 * Sample call for ClearGridData operation/method
 */
if ($clear->ClearGridData(new \StructType\ClearGridData()) !== false) {
    print_r($clear->getResult());
} else {
    print_r($clear->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \ServiceType\Remove($options);
/**
 * Sample call for RemoveRowData operation/method
 */
if ($remove->RemoveRowData(new \StructType\RemoveRowData()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for Modify ServiceType
 */
$modify = new \ServiceType\Modify($options);
/**
 * Sample call for ModifyRowData operation/method
 */
if ($modify->ModifyRowData(new \StructType\ModifyRowData()) !== false) {
    print_r($modify->getResult());
} else {
    print_r($modify->getLastError());
}
/**
 * Samples for Find ServiceType
 */
$find = new \ServiceType\Find($options);
/**
 * Sample call for FindFormData operation/method
 */
if ($find->FindFormData(new \StructType\FindFormData()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
