<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoginResponse StructType
 * @subpackage Structs
 */
class LoginResponse extends AbstractStructBase
{
    /**
     * The LoginResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LoginResult;
    /**
     * Constructor method for LoginResponse
     * @uses LoginResponse::setLoginResult()
     * @param string $loginResult
     */
    public function __construct($loginResult = null)
    {
        $this
            ->setLoginResult($loginResult);
    }
    /**
     * Get LoginResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoginResult()
    {
        return isset($this->LoginResult) ? $this->LoginResult : null;
    }
    /**
     * Set LoginResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loginResult
     * @return \StructType\LoginResponse
     */
    public function setLoginResult($loginResult = null)
    {
        // validation for constraint: pattern
        if (is_scalar($loginResult) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $loginResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($loginResult, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($loginResult) && !is_string($loginResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loginResult)), __LINE__);
        }
        if (is_null($loginResult) || (is_array($loginResult) && empty($loginResult))) {
            unset($this->LoginResult);
        } else {
            $this->LoginResult = $loginResult;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LoginResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
