<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsuranceAreaContract StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:InsuranceAreaContract
 * @subpackage Structs
 */
class InsuranceAreaContract extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The IsuranceDistricts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfInsuranceAreaContract
     */
    public $IsuranceDistricts;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * Constructor method for InsuranceAreaContract
     * @uses InsuranceAreaContract::setCode()
     * @uses InsuranceAreaContract::setIsuranceDistricts()
     * @uses InsuranceAreaContract::setName()
     * @param string $code
     * @param \ArrayType\ArrayOfInsuranceAreaContract $isuranceDistricts
     * @param string $name
     */
    public function __construct($code = null, \ArrayType\ArrayOfInsuranceAreaContract $isuranceDistricts = null, $name = null)
    {
        $this
            ->setCode($code)
            ->setIsuranceDistricts($isuranceDistricts)
            ->setName($name);
    }
    /**
     * Get Code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCode()
    {
        return isset($this->Code) ? $this->Code : null;
    }
    /**
     * Set Code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $code
     * @return \StructType\InsuranceAreaContract
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->Code);
        } else {
            $this->Code = $code;
        }
        return $this;
    }
    /**
     * Get IsuranceDistricts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfInsuranceAreaContract|null
     */
    public function getIsuranceDistricts()
    {
        return isset($this->IsuranceDistricts) ? $this->IsuranceDistricts : null;
    }
    /**
     * Set IsuranceDistricts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfInsuranceAreaContract $isuranceDistricts
     * @return \StructType\InsuranceAreaContract
     */
    public function setIsuranceDistricts(\ArrayType\ArrayOfInsuranceAreaContract $isuranceDistricts = null)
    {
        if (is_null($isuranceDistricts) || (is_array($isuranceDistricts) && empty($isuranceDistricts))) {
            unset($this->IsuranceDistricts);
        } else {
            $this->IsuranceDistricts = $isuranceDistricts;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\InsuranceAreaContract
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InsuranceAreaContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
