<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HmisFormDataContract StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:HmisFormDataContract
 * @subpackage Structs
 */
class HmisFormDataContract extends AbstractStructBase
{
    /**
     * The CommitStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RecordStatusContract
     */
    public $CommitStatus;
    /**
     * The ContractID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ContractID;
    /**
     * The FormFieldsData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfKeyValueOfstringanyType
     */
    public $FormFieldsData;
    /**
     * The FormGridsData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfKeyValueOfstringArrayOfHmisFormDataContractNObIUIam
     */
    public $FormGridsData;
    /**
     * The FormID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FormID;
    /**
     * The SubFormsData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfHmisFormDataContract
     */
    public $SubFormsData;
    /**
     * The ValidationComment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidationComment;
    /**
     * The ValidationStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RecordStatusContract
     */
    public $ValidationStatus;
    /**
     * Constructor method for HmisFormDataContract
     * @uses HmisFormDataContract::setCommitStatus()
     * @uses HmisFormDataContract::setContractID()
     * @uses HmisFormDataContract::setFormFieldsData()
     * @uses HmisFormDataContract::setFormGridsData()
     * @uses HmisFormDataContract::setFormID()
     * @uses HmisFormDataContract::setSubFormsData()
     * @uses HmisFormDataContract::setValidationComment()
     * @uses HmisFormDataContract::setValidationStatus()
     * @param \StructType\RecordStatusContract $commitStatus
     * @param string $contractID
     * @param \ArrayType\ArrayOfKeyValueOfstringanyType $formFieldsData
     * @param \ArrayType\ArrayOfKeyValueOfstringArrayOfHmisFormDataContractNObIUIam $formGridsData
     * @param string $formID
     * @param \ArrayType\ArrayOfHmisFormDataContract $subFormsData
     * @param string $validationComment
     * @param \StructType\RecordStatusContract $validationStatus
     */
    public function __construct(\StructType\RecordStatusContract $commitStatus = null, $contractID = null, \ArrayType\ArrayOfKeyValueOfstringanyType $formFieldsData = null, \ArrayType\ArrayOfKeyValueOfstringArrayOfHmisFormDataContractNObIUIam $formGridsData = null, $formID = null, \ArrayType\ArrayOfHmisFormDataContract $subFormsData = null, $validationComment = null, \StructType\RecordStatusContract $validationStatus = null)
    {
        $this
            ->setCommitStatus($commitStatus)
            ->setContractID($contractID)
            ->setFormFieldsData($formFieldsData)
            ->setFormGridsData($formGridsData)
            ->setFormID($formID)
            ->setSubFormsData($subFormsData)
            ->setValidationComment($validationComment)
            ->setValidationStatus($validationStatus);
    }
    /**
     * Get CommitStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RecordStatusContract|null
     */
    public function getCommitStatus()
    {
        return isset($this->CommitStatus) ? $this->CommitStatus : null;
    }
    /**
     * Set CommitStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RecordStatusContract $commitStatus
     * @return \StructType\HmisFormDataContract
     */
    public function setCommitStatus(\StructType\RecordStatusContract $commitStatus = null)
    {
        if (is_null($commitStatus) || (is_array($commitStatus) && empty($commitStatus))) {
            unset($this->CommitStatus);
        } else {
            $this->CommitStatus = $commitStatus;
        }
        return $this;
    }
    /**
     * Get ContractID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContractID()
    {
        return isset($this->ContractID) ? $this->ContractID : null;
    }
    /**
     * Set ContractID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contractID
     * @return \StructType\HmisFormDataContract
     */
    public function setContractID($contractID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($contractID) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $contractID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($contractID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contractID) && !is_string($contractID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractID)), __LINE__);
        }
        if (is_null($contractID) || (is_array($contractID) && empty($contractID))) {
            unset($this->ContractID);
        } else {
            $this->ContractID = $contractID;
        }
        return $this;
    }
    /**
     * Get FormFieldsData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfKeyValueOfstringanyType|null
     */
    public function getFormFieldsData()
    {
        return isset($this->FormFieldsData) ? $this->FormFieldsData : null;
    }
    /**
     * Set FormFieldsData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfKeyValueOfstringanyType $formFieldsData
     * @return \StructType\HmisFormDataContract
     */
    public function setFormFieldsData(\ArrayType\ArrayOfKeyValueOfstringanyType $formFieldsData = null)
    {
        if (is_null($formFieldsData) || (is_array($formFieldsData) && empty($formFieldsData))) {
            unset($this->FormFieldsData);
        } else {
            $this->FormFieldsData = $formFieldsData;
        }
        return $this;
    }
    /**
     * Get FormGridsData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfKeyValueOfstringArrayOfHmisFormDataContractNObIUIam|null
     */
    public function getFormGridsData()
    {
        return isset($this->FormGridsData) ? $this->FormGridsData : null;
    }
    /**
     * Set FormGridsData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfKeyValueOfstringArrayOfHmisFormDataContractNObIUIam $formGridsData
     * @return \StructType\HmisFormDataContract
     */
    public function setFormGridsData(\ArrayType\ArrayOfKeyValueOfstringArrayOfHmisFormDataContractNObIUIam $formGridsData = null)
    {
        if (is_null($formGridsData) || (is_array($formGridsData) && empty($formGridsData))) {
            unset($this->FormGridsData);
        } else {
            $this->FormGridsData = $formGridsData;
        }
        return $this;
    }
    /**
     * Get FormID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormID()
    {
        return isset($this->FormID) ? $this->FormID : null;
    }
    /**
     * Set FormID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formID
     * @return \StructType\HmisFormDataContract
     */
    public function setFormID($formID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($formID) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $formID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($formID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($formID) && !is_string($formID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formID)), __LINE__);
        }
        if (is_null($formID) || (is_array($formID) && empty($formID))) {
            unset($this->FormID);
        } else {
            $this->FormID = $formID;
        }
        return $this;
    }
    /**
     * Get SubFormsData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfHmisFormDataContract|null
     */
    public function getSubFormsData()
    {
        return isset($this->SubFormsData) ? $this->SubFormsData : null;
    }
    /**
     * Set SubFormsData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfHmisFormDataContract $subFormsData
     * @return \StructType\HmisFormDataContract
     */
    public function setSubFormsData(\ArrayType\ArrayOfHmisFormDataContract $subFormsData = null)
    {
        if (is_null($subFormsData) || (is_array($subFormsData) && empty($subFormsData))) {
            unset($this->SubFormsData);
        } else {
            $this->SubFormsData = $subFormsData;
        }
        return $this;
    }
    /**
     * Get ValidationComment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidationComment()
    {
        return isset($this->ValidationComment) ? $this->ValidationComment : null;
    }
    /**
     * Set ValidationComment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validationComment
     * @return \StructType\HmisFormDataContract
     */
    public function setValidationComment($validationComment = null)
    {
        // validation for constraint: string
        if (!is_null($validationComment) && !is_string($validationComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validationComment)), __LINE__);
        }
        if (is_null($validationComment) || (is_array($validationComment) && empty($validationComment))) {
            unset($this->ValidationComment);
        } else {
            $this->ValidationComment = $validationComment;
        }
        return $this;
    }
    /**
     * Get ValidationStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RecordStatusContract|null
     */
    public function getValidationStatus()
    {
        return isset($this->ValidationStatus) ? $this->ValidationStatus : null;
    }
    /**
     * Set ValidationStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RecordStatusContract $validationStatus
     * @return \StructType\HmisFormDataContract
     */
    public function setValidationStatus(\StructType\RecordStatusContract $validationStatus = null)
    {
        if (is_null($validationStatus) || (is_array($validationStatus) && empty($validationStatus))) {
            unset($this->ValidationStatus);
        } else {
            $this->ValidationStatus = $validationStatus;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HmisFormDataContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
