<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetAllSchemas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllSchemas $parameters
     * @return \StructType\GetAllSchemasResponse|bool
     */
    public function GetAllSchemas(\StructType\GetAllSchemas $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllSchemas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFormSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFormSchema $parameters
     * @return \StructType\GetFormSchemaResponse|bool
     */
    public function GetFormSchema(\StructType\GetFormSchema $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFormSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetAllStatuses
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAllStatuses $parameters
     * @return \StructType\GetAllStatusesResponse|bool
     */
    public function GetAllStatuses(\StructType\GetAllStatuses $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetAllStatuses($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRegionDistricts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRegionDistricts $parameters
     * @return \StructType\GetRegionDistrictsResponse|bool
     */
    public function GetRegionDistricts(\StructType\GetRegionDistricts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRegionDistricts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetFormData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetFormData $parameters
     * @return \StructType\GetFormDataResponse|bool
     */
    public function GetFormData(\StructType\GetFormData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetFormData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRowData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRowData $parameters
     * @return \StructType\GetRowDataResponse|bool
     */
    public function GetRowData(\StructType\GetRowData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRowData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetGridData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetGridData $parameters
     * @return \StructType\GetGridDataResponse|bool
     */
    public function GetGridData(\StructType\GetGridData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetGridData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAllSchemasResponse|\StructType\GetAllStatusesResponse|\StructType\GetFormDataResponse|\StructType\GetFormSchemaResponse|\StructType\GetGridDataResponse|\StructType\GetRegionDistrictsResponse|\StructType\GetRowDataResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
