<?php

namespace EnumType;

/**
 * This class stands for RecordStatusTypeEnum EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RecordStatusTypeEnum
 * @subpackage Enumerations
 */
class RecordStatusTypeEnum
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'Submission'
     * @return string 'Submission'
     */
    const VALUE_SUBMISSION = 'Submission';
    /**
     * Constant for value 'Validation'
     * @return string 'Validation'
     */
    const VALUE_VALIDATION = 'Validation';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_SUBMISSION
     * @uses self::VALUE_VALIDATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_SUBMISSION,
            self::VALUE_VALIDATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
