<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfshort ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfshort
 * @subpackage Arrays
 */
class ArrayOfshort extends AbstractStructArrayBase
{
    /**
     * The short
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var int[]
     */
    public $short;
    /**
     * Constructor method for ArrayOfshort
     * @uses ArrayOfshort::setShort()
     * @param int[] $short
     */
    public function __construct(array $short = array())
    {
        $this
            ->setShort($short);
    }
    /**
     * Get short value
     * @return int[]|null
     */
    public function getShort()
    {
        return $this->short;
    }
    /**
     * Set short value
     * @throws \InvalidArgumentException
     * @param int[] $short
     * @return \ArrayType\ArrayOfshort
     */
    public function setShort(array $short = array())
    {
        foreach ($short as $arrayOfshortShortItem) {
            // validation for constraint: itemType
            if (!is_numeric($arrayOfshortShortItem)) {
                throw new \InvalidArgumentException(sprintf('The short property can only contain items of short, "%s" given', is_object($arrayOfshortShortItem) ? get_class($arrayOfshortShortItem) : gettype($arrayOfshortShortItem)), __LINE__);
            }
        }
        $this->short = $short;
        return $this;
    }
    /**
     * Add item to short value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \ArrayType\ArrayOfshort
     */
    public function addToShort($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The short property can only contain items of short, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->short[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return int|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return int|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return int|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return int|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return int|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string short
     */
    public function getAttributeName()
    {
        return 'short';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfshort
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
