<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNullableOfboolean ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfNullableOfboolean
 * @subpackage Arrays
 */
class ArrayOfNullableOfboolean extends AbstractStructArrayBase
{
    /**
     * The boolean
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var bool[]
     */
    public $boolean;
    /**
     * Constructor method for ArrayOfNullableOfboolean
     * @uses ArrayOfNullableOfboolean::setBoolean()
     * @param bool[] $boolean
     */
    public function __construct(array $boolean = array())
    {
        $this
            ->setBoolean($boolean);
    }
    /**
     * Get boolean value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool[]|null
     */
    public function getBoolean()
    {
        return isset($this->boolean) ? $this->boolean : null;
    }
    /**
     * Set boolean value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param bool[] $boolean
     * @return \ArrayType\ArrayOfNullableOfboolean
     */
    public function setBoolean(array $boolean = array())
    {
        foreach ($boolean as $arrayOfNullableOfbooleanBooleanItem) {
            // validation for constraint: itemType
            if (!is_bool($arrayOfNullableOfbooleanBooleanItem)) {
                throw new \InvalidArgumentException(sprintf('The boolean property can only contain items of boolean, "%s" given', is_object($arrayOfNullableOfbooleanBooleanItem) ? get_class($arrayOfNullableOfbooleanBooleanItem) : gettype($arrayOfNullableOfbooleanBooleanItem)), __LINE__);
            }
        }
        if (is_null($boolean) || (is_array($boolean) && empty($boolean))) {
            unset($this->boolean);
        } else {
            $this->boolean = $boolean;
        }
        return $this;
    }
    /**
     * Add item to boolean value
     * @throws \InvalidArgumentException
     * @param bool $item
     * @return \ArrayType\ArrayOfNullableOfboolean
     */
    public function addToBoolean($item)
    {
        // validation for constraint: itemType
        if (!is_bool($item)) {
            throw new \InvalidArgumentException(sprintf('The boolean property can only contain items of boolean, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->boolean[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return bool|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return bool|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return bool|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return bool|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return bool|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string boolean
     */
    public function getAttributeName()
    {
        return 'boolean';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfNullableOfboolean
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
