<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfComplex ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfComplex
 * @subpackage Arrays
 */
class ArrayOfComplex extends AbstractStructArrayBase
{
    /**
     * The Complex
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Complex[]
     */
    public $Complex;
    /**
     * Constructor method for ArrayOfComplex
     * @uses ArrayOfComplex::setComplex()
     * @param \StructType\Complex[] $complex
     */
    public function __construct(array $complex = array())
    {
        $this
            ->setComplex($complex);
    }
    /**
     * Get Complex value
     * @return \StructType\Complex[]|null
     */
    public function getComplex()
    {
        return $this->Complex;
    }
    /**
     * Set Complex value
     * @throws \InvalidArgumentException
     * @param \StructType\Complex[] $complex
     * @return \ArrayType\ArrayOfComplex
     */
    public function setComplex(array $complex = array())
    {
        foreach ($complex as $arrayOfComplexComplexItem) {
            // validation for constraint: itemType
            if (!$arrayOfComplexComplexItem instanceof \StructType\Complex) {
                throw new \InvalidArgumentException(sprintf('The Complex property can only contain items of \StructType\Complex, "%s" given', is_object($arrayOfComplexComplexItem) ? get_class($arrayOfComplexComplexItem) : gettype($arrayOfComplexComplexItem)), __LINE__);
            }
        }
        $this->Complex = $complex;
        return $this;
    }
    /**
     * Add item to Complex value
     * @throws \InvalidArgumentException
     * @param \StructType\Complex $item
     * @return \ArrayType\ArrayOfComplex
     */
    public function addToComplex(\StructType\Complex $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Complex) {
            throw new \InvalidArgumentException(sprintf('The Complex property can only contain items of \StructType\Complex, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Complex[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Complex|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Complex|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Complex|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Complex|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Complex|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Complex
     */
    public function getAttributeName()
    {
        return 'Complex';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfComplex
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
