<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBigInteger ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfBigInteger
 * @subpackage Arrays
 */
class ArrayOfBigInteger extends AbstractStructArrayBase
{
    /**
     * The BigInteger
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BigInteger[]
     */
    public $BigInteger;
    /**
     * Constructor method for ArrayOfBigInteger
     * @uses ArrayOfBigInteger::setBigInteger()
     * @param \StructType\BigInteger[] $bigInteger
     */
    public function __construct(array $bigInteger = array())
    {
        $this
            ->setBigInteger($bigInteger);
    }
    /**
     * Get BigInteger value
     * @return \StructType\BigInteger[]|null
     */
    public function getBigInteger()
    {
        return $this->BigInteger;
    }
    /**
     * Set BigInteger value
     * @throws \InvalidArgumentException
     * @param \StructType\BigInteger[] $bigInteger
     * @return \ArrayType\ArrayOfBigInteger
     */
    public function setBigInteger(array $bigInteger = array())
    {
        foreach ($bigInteger as $arrayOfBigIntegerBigIntegerItem) {
            // validation for constraint: itemType
            if (!$arrayOfBigIntegerBigIntegerItem instanceof \StructType\BigInteger) {
                throw new \InvalidArgumentException(sprintf('The BigInteger property can only contain items of \StructType\BigInteger, "%s" given', is_object($arrayOfBigIntegerBigIntegerItem) ? get_class($arrayOfBigIntegerBigIntegerItem) : gettype($arrayOfBigIntegerBigIntegerItem)), __LINE__);
            }
        }
        $this->BigInteger = $bigInteger;
        return $this;
    }
    /**
     * Add item to BigInteger value
     * @throws \InvalidArgumentException
     * @param \StructType\BigInteger $item
     * @return \ArrayType\ArrayOfBigInteger
     */
    public function addToBigInteger(\StructType\BigInteger $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BigInteger) {
            throw new \InvalidArgumentException(sprintf('The BigInteger property can only contain items of \StructType\BigInteger, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BigInteger[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BigInteger|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BigInteger|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BigInteger|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BigInteger|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BigInteger|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BigInteger
     */
    public function getAttributeName()
    {
        return 'BigInteger';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfBigInteger
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
