<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormSchemaContract StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:FormSchemaContract
 * @subpackage Structs
 */
class FormSchemaContract extends ExecutionResultContract
{
    /**
     * The Alias
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Alias;
    /**
     * The ContractID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ContractID;
    /**
     * The FormFields
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfFormFieldSchemaContract
     */
    public $FormFields;
    /**
     * The FormGrids
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfGridSchemaContract
     */
    public $FormGrids;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The SubForms
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfFormSchemaContract
     */
    public $SubForms;
    /**
     * Constructor method for FormSchemaContract
     * @uses FormSchemaContract::setAlias()
     * @uses FormSchemaContract::setContractID()
     * @uses FormSchemaContract::setFormFields()
     * @uses FormSchemaContract::setFormGrids()
     * @uses FormSchemaContract::setID()
     * @uses FormSchemaContract::setName()
     * @uses FormSchemaContract::setSubForms()
     * @param string $alias
     * @param string $contractID
     * @param \ArrayType\ArrayOfFormFieldSchemaContract $formFields
     * @param \ArrayType\ArrayOfGridSchemaContract $formGrids
     * @param string $iD
     * @param string $name
     * @param \ArrayType\ArrayOfFormSchemaContract $subForms
     */
    public function __construct($alias = null, $contractID = null, \ArrayType\ArrayOfFormFieldSchemaContract $formFields = null, \ArrayType\ArrayOfGridSchemaContract $formGrids = null, $iD = null, $name = null, \ArrayType\ArrayOfFormSchemaContract $subForms = null)
    {
        $this
            ->setAlias($alias)
            ->setContractID($contractID)
            ->setFormFields($formFields)
            ->setFormGrids($formGrids)
            ->setID($iD)
            ->setName($name)
            ->setSubForms($subForms);
    }
    /**
     * Get Alias value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlias()
    {
        return isset($this->Alias) ? $this->Alias : null;
    }
    /**
     * Set Alias value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alias
     * @return \StructType\FormSchemaContract
     */
    public function setAlias($alias = null)
    {
        // validation for constraint: string
        if (!is_null($alias) && !is_string($alias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alias)), __LINE__);
        }
        if (is_null($alias) || (is_array($alias) && empty($alias))) {
            unset($this->Alias);
        } else {
            $this->Alias = $alias;
        }
        return $this;
    }
    /**
     * Get ContractID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContractID()
    {
        return isset($this->ContractID) ? $this->ContractID : null;
    }
    /**
     * Set ContractID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contractID
     * @return \StructType\FormSchemaContract
     */
    public function setContractID($contractID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($contractID) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $contractID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($contractID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contractID) && !is_string($contractID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractID)), __LINE__);
        }
        if (is_null($contractID) || (is_array($contractID) && empty($contractID))) {
            unset($this->ContractID);
        } else {
            $this->ContractID = $contractID;
        }
        return $this;
    }
    /**
     * Get FormFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfFormFieldSchemaContract|null
     */
    public function getFormFields()
    {
        return isset($this->FormFields) ? $this->FormFields : null;
    }
    /**
     * Set FormFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfFormFieldSchemaContract $formFields
     * @return \StructType\FormSchemaContract
     */
    public function setFormFields(\ArrayType\ArrayOfFormFieldSchemaContract $formFields = null)
    {
        if (is_null($formFields) || (is_array($formFields) && empty($formFields))) {
            unset($this->FormFields);
        } else {
            $this->FormFields = $formFields;
        }
        return $this;
    }
    /**
     * Get FormGrids value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfGridSchemaContract|null
     */
    public function getFormGrids()
    {
        return isset($this->FormGrids) ? $this->FormGrids : null;
    }
    /**
     * Set FormGrids value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfGridSchemaContract $formGrids
     * @return \StructType\FormSchemaContract
     */
    public function setFormGrids(\ArrayType\ArrayOfGridSchemaContract $formGrids = null)
    {
        if (is_null($formGrids) || (is_array($formGrids) && empty($formGrids))) {
            unset($this->FormGrids);
        } else {
            $this->FormGrids = $formGrids;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\FormSchemaContract
     */
    public function setID($iD = null)
    {
        // validation for constraint: pattern
        if (is_scalar($iD) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($iD, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\FormSchemaContract
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get SubForms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfFormSchemaContract|null
     */
    public function getSubForms()
    {
        return isset($this->SubForms) ? $this->SubForms : null;
    }
    /**
     * Set SubForms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfFormSchemaContract $subForms
     * @return \StructType\FormSchemaContract
     */
    public function setSubForms(\ArrayType\ArrayOfFormSchemaContract $subForms = null)
    {
        if (is_null($subForms) || (is_array($subForms) && empty($subForms))) {
            unset($this->SubForms);
        } else {
            $this->SubForms = $subForms;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FormSchemaContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
