<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfduration ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfduration
 * @subpackage Arrays
 */
class ArrayOfduration extends AbstractStructArrayBase
{
    /**
     * The duration
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string[]
     */
    public $duration;
    /**
     * Constructor method for ArrayOfduration
     * @uses ArrayOfduration::setDuration()
     * @param string[] $duration
     */
    public function __construct(array $duration = array())
    {
        $this
            ->setDuration($duration);
    }
    /**
     * Get duration value
     * @return string[]|null
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * Set duration value
     * @throws \InvalidArgumentException
     * @param string[] $duration
     * @return \ArrayType\ArrayOfduration
     */
    public function setDuration(array $duration = array())
    {
        // validation for constraint: pattern
        if (is_scalar($duration) && !preg_match('/\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?/', $duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?", "%s" given', var_export($duration, true)), __LINE__);
        }
        foreach ($duration as $arrayOfdurationDurationItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfdurationDurationItem)) {
                throw new \InvalidArgumentException(sprintf('The duration property can only contain items of duration, "%s" given', is_object($arrayOfdurationDurationItem) ? get_class($arrayOfdurationDurationItem) : gettype($arrayOfdurationDurationItem)), __LINE__);
            }
        }
        $this->duration = $duration;
        return $this;
    }
    /**
     * Add item to duration value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfduration
     */
    public function addToDuration($item)
    {
        // validation for constraint: pattern
        if (is_scalar($item) && !preg_match('/\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?", "%s" given', var_export($item, true)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The duration property can only contain items of duration, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->duration[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string duration
     */
    public function getAttributeName()
    {
        return 'duration';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfduration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
