<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfdecimal ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfdecimal
 * @subpackage Arrays
 */
class ArrayOfdecimal extends AbstractStructArrayBase
{
    /**
     * The decimal
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var float[]
     */
    public $decimal;
    /**
     * Constructor method for ArrayOfdecimal
     * @uses ArrayOfdecimal::setDecimal()
     * @param float[] $decimal
     */
    public function __construct(array $decimal = array())
    {
        $this
            ->setDecimal($decimal);
    }
    /**
     * Get decimal value
     * @return float[]|null
     */
    public function getDecimal()
    {
        return $this->decimal;
    }
    /**
     * Set decimal value
     * @throws \InvalidArgumentException
     * @param float[] $decimal
     * @return \ArrayType\ArrayOfdecimal
     */
    public function setDecimal(array $decimal = array())
    {
        foreach ($decimal as $arrayOfdecimalDecimalItem) {
            // validation for constraint: itemType
            if (!is_float($arrayOfdecimalDecimalItem)) {
                throw new \InvalidArgumentException(sprintf('The decimal property can only contain items of decimal, "%s" given', is_object($arrayOfdecimalDecimalItem) ? get_class($arrayOfdecimalDecimalItem) : gettype($arrayOfdecimalDecimalItem)), __LINE__);
            }
        }
        $this->decimal = $decimal;
        return $this;
    }
    /**
     * Add item to decimal value
     * @throws \InvalidArgumentException
     * @param float $item
     * @return \ArrayType\ArrayOfdecimal
     */
    public function addToDecimal($item)
    {
        // validation for constraint: itemType
        if (!is_float($item)) {
            throw new \InvalidArgumentException(sprintf('The decimal property can only contain items of decimal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->decimal[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return float|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return float|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return float|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return float|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return float|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string decimal
     */
    public function getAttributeName()
    {
        return 'decimal';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfdecimal
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
