<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StringBuilder StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:StringBuilder
 * @subpackage Structs
 */
class StringBuilder extends AbstractStructBase
{
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The FactoryType
     * Meta informations extracted from the WSDL
     * - ref: ser:FactoryType
     * @var string
     */
    public $FactoryType;
    /**
     * Constructor method for StringBuilder
     * @uses StringBuilder::setAny()
     * @uses StringBuilder::setFactoryType()
     * @param \DOMDocument $any
     * @param string $factoryType
     */
    public function __construct(\DOMDocument $any = null, $factoryType = null)
    {
        $this
            ->setAny($any)
            ->setFactoryType($factoryType);
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \StructType\StringBuilder::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \StructType\StringBuilder
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Get FactoryType value
     * @return string|null
     */
    public function getFactoryType()
    {
        return $this->FactoryType;
    }
    /**
     * Set FactoryType value
     * @param string $factoryType
     * @return \StructType\StringBuilder
     */
    public function setFactoryType($factoryType = null)
    {
        // validation for constraint: string
        if (!is_null($factoryType) && !is_string($factoryType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($factoryType)), __LINE__);
        }
        $this->FactoryType = $factoryType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StringBuilder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
