<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GridSchemaContract StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GridSchemaContract
 * @subpackage Structs
 */
class GridSchemaContract extends AbstractStructBase
{
    /**
     * The Alias
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Alias;
    /**
     * The DetailsForm
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FormSchemaContract
     */
    public $DetailsForm;
    /**
     * The GridFields
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfGridFieldSchemaContract
     */
    public $GridFields;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * Constructor method for GridSchemaContract
     * @uses GridSchemaContract::setAlias()
     * @uses GridSchemaContract::setDetailsForm()
     * @uses GridSchemaContract::setGridFields()
     * @uses GridSchemaContract::setID()
     * @uses GridSchemaContract::setName()
     * @param string $alias
     * @param \StructType\FormSchemaContract $detailsForm
     * @param \ArrayType\ArrayOfGridFieldSchemaContract $gridFields
     * @param string $iD
     * @param string $name
     */
    public function __construct($alias = null, \StructType\FormSchemaContract $detailsForm = null, \ArrayType\ArrayOfGridFieldSchemaContract $gridFields = null, $iD = null, $name = null)
    {
        $this
            ->setAlias($alias)
            ->setDetailsForm($detailsForm)
            ->setGridFields($gridFields)
            ->setID($iD)
            ->setName($name);
    }
    /**
     * Get Alias value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlias()
    {
        return isset($this->Alias) ? $this->Alias : null;
    }
    /**
     * Set Alias value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alias
     * @return \StructType\GridSchemaContract
     */
    public function setAlias($alias = null)
    {
        // validation for constraint: string
        if (!is_null($alias) && !is_string($alias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alias)), __LINE__);
        }
        if (is_null($alias) || (is_array($alias) && empty($alias))) {
            unset($this->Alias);
        } else {
            $this->Alias = $alias;
        }
        return $this;
    }
    /**
     * Get DetailsForm value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FormSchemaContract|null
     */
    public function getDetailsForm()
    {
        return isset($this->DetailsForm) ? $this->DetailsForm : null;
    }
    /**
     * Set DetailsForm value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\FormSchemaContract $detailsForm
     * @return \StructType\GridSchemaContract
     */
    public function setDetailsForm(\StructType\FormSchemaContract $detailsForm = null)
    {
        if (is_null($detailsForm) || (is_array($detailsForm) && empty($detailsForm))) {
            unset($this->DetailsForm);
        } else {
            $this->DetailsForm = $detailsForm;
        }
        return $this;
    }
    /**
     * Get GridFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfGridFieldSchemaContract|null
     */
    public function getGridFields()
    {
        return isset($this->GridFields) ? $this->GridFields : null;
    }
    /**
     * Set GridFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfGridFieldSchemaContract $gridFields
     * @return \StructType\GridSchemaContract
     */
    public function setGridFields(\ArrayType\ArrayOfGridFieldSchemaContract $gridFields = null)
    {
        if (is_null($gridFields) || (is_array($gridFields) && empty($gridFields))) {
            unset($this->GridFields);
        } else {
            $this->GridFields = $gridFields;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\GridSchemaContract
     */
    public function setID($iD = null)
    {
        // validation for constraint: pattern
        if (is_scalar($iD) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($iD, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\GridSchemaContract
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GridSchemaContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
