<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GridRowDataContract StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GridRowDataContract
 * @subpackage Structs
 */
class GridRowDataContract extends ExecutionResultContract
{
    /**
     * The Fields
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfKeyValueOfstringanyType
     */
    public $Fields;
    /**
     * The FormID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FormID;
    /**
     * The GridName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GridName;
    /**
     * Constructor method for GridRowDataContract
     * @uses GridRowDataContract::setFields()
     * @uses GridRowDataContract::setFormID()
     * @uses GridRowDataContract::setGridName()
     * @param \ArrayType\ArrayOfKeyValueOfstringanyType $fields
     * @param string $formID
     * @param string $gridName
     */
    public function __construct(\ArrayType\ArrayOfKeyValueOfstringanyType $fields = null, $formID = null, $gridName = null)
    {
        $this
            ->setFields($fields)
            ->setFormID($formID)
            ->setGridName($gridName);
    }
    /**
     * Get Fields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfKeyValueOfstringanyType|null
     */
    public function getFields()
    {
        return isset($this->Fields) ? $this->Fields : null;
    }
    /**
     * Set Fields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfKeyValueOfstringanyType $fields
     * @return \StructType\GridRowDataContract
     */
    public function setFields(\ArrayType\ArrayOfKeyValueOfstringanyType $fields = null)
    {
        if (is_null($fields) || (is_array($fields) && empty($fields))) {
            unset($this->Fields);
        } else {
            $this->Fields = $fields;
        }
        return $this;
    }
    /**
     * Get FormID value
     * @return string|null
     */
    public function getFormID()
    {
        return $this->FormID;
    }
    /**
     * Set FormID value
     * @param string $formID
     * @return \StructType\GridRowDataContract
     */
    public function setFormID($formID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($formID) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $formID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($formID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($formID) && !is_string($formID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formID)), __LINE__);
        }
        $this->FormID = $formID;
        return $this;
    }
    /**
     * Get GridName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGridName()
    {
        return isset($this->GridName) ? $this->GridName : null;
    }
    /**
     * Set GridName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gridName
     * @return \StructType\GridRowDataContract
     */
    public function setGridName($gridName = null)
    {
        // validation for constraint: string
        if (!is_null($gridName) && !is_string($gridName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gridName)), __LINE__);
        }
        if (is_null($gridName) || (is_array($gridName) && empty($gridName))) {
            unset($this->GridName);
        } else {
            $this->GridName = $gridName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GridRowDataContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
