<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClearFormData StructType
 * @subpackage Structs
 */
class ClearFormData extends AbstractStructBase
{
    /**
     * The loginToken
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $loginToken;
    /**
     * The contractID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $contractID;
    /**
     * The formID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $formID;
    /**
     * Constructor method for ClearFormData
     * @uses ClearFormData::setLoginToken()
     * @uses ClearFormData::setContractID()
     * @uses ClearFormData::setFormID()
     * @param string $loginToken
     * @param string $contractID
     * @param string $formID
     */
    public function __construct($loginToken = null, $contractID = null, $formID = null)
    {
        $this
            ->setLoginToken($loginToken)
            ->setContractID($contractID)
            ->setFormID($formID);
    }
    /**
     * Get loginToken value
     * @return string|null
     */
    public function getLoginToken()
    {
        return $this->loginToken;
    }
    /**
     * Set loginToken value
     * @param string $loginToken
     * @return \StructType\ClearFormData
     */
    public function setLoginToken($loginToken = null)
    {
        // validation for constraint: pattern
        if (is_scalar($loginToken) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($loginToken, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($loginToken) && !is_string($loginToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loginToken)), __LINE__);
        }
        $this->loginToken = $loginToken;
        return $this;
    }
    /**
     * Get contractID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContractID()
    {
        return isset($this->contractID) ? $this->contractID : null;
    }
    /**
     * Set contractID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contractID
     * @return \StructType\ClearFormData
     */
    public function setContractID($contractID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($contractID) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $contractID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($contractID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contractID) && !is_string($contractID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractID)), __LINE__);
        }
        if (is_null($contractID) || (is_array($contractID) && empty($contractID))) {
            unset($this->contractID);
        } else {
            $this->contractID = $contractID;
        }
        return $this;
    }
    /**
     * Get formID value
     * @return string|null
     */
    public function getFormID()
    {
        return $this->formID;
    }
    /**
     * Set formID value
     * @param string $formID
     * @return \StructType\ClearFormData
     */
    public function setFormID($formID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($formID) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $formID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($formID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($formID) && !is_string($formID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formID)), __LINE__);
        }
        $this->formID = $formID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClearFormData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
