<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOffloat ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOffloat
 * @subpackage Arrays
 */
class ArrayOffloat extends AbstractStructArrayBase
{
    /**
     * The float
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var float[]
     */
    public $float;
    /**
     * Constructor method for ArrayOffloat
     * @uses ArrayOffloat::setFloat()
     * @param float[] $float
     */
    public function __construct(array $float = array())
    {
        $this
            ->setFloat($float);
    }
    /**
     * Get float value
     * @return float[]|null
     */
    public function getFloat()
    {
        return $this->float;
    }
    /**
     * Set float value
     * @throws \InvalidArgumentException
     * @param float[] $float
     * @return \ArrayType\ArrayOffloat
     */
    public function setFloat(array $float = array())
    {
        foreach ($float as $arrayOffloatFloatItem) {
            // validation for constraint: itemType
            if (!is_float($arrayOffloatFloatItem)) {
                throw new \InvalidArgumentException(sprintf('The float property can only contain items of float, "%s" given', is_object($arrayOffloatFloatItem) ? get_class($arrayOffloatFloatItem) : gettype($arrayOffloatFloatItem)), __LINE__);
            }
        }
        $this->float = $float;
        return $this;
    }
    /**
     * Add item to float value
     * @throws \InvalidArgumentException
     * @param float $item
     * @return \ArrayType\ArrayOffloat
     */
    public function addToFloat($item)
    {
        // validation for constraint: itemType
        if (!is_float($item)) {
            throw new \InvalidArgumentException(sprintf('The float property can only contain items of float, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->float[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return float|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return float|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return float|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return float|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return float|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string float
     */
    public function getAttributeName()
    {
        return 'float';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOffloat
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
