<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfchar ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfchar
 * @subpackage Arrays
 */
class ArrayOfchar extends AbstractStructArrayBase
{
    /**
     * The char
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * - type: tns:char
     * @var int[]
     */
    public $char;
    /**
     * Constructor method for ArrayOfchar
     * @uses ArrayOfchar::setChar()
     * @param int[] $char
     */
    public function __construct(array $char = array())
    {
        $this
            ->setChar($char);
    }
    /**
     * Get char value
     * @return int[]|null
     */
    public function getChar()
    {
        return $this->char;
    }
    /**
     * Set char value
     * @throws \InvalidArgumentException
     * @param int[] $char
     * @return \ArrayType\ArrayOfchar
     */
    public function setChar(array $char = array())
    {
        foreach ($char as $arrayOfcharCharItem) {
            // validation for constraint: itemType
            if (!is_numeric($arrayOfcharCharItem)) {
                throw new \InvalidArgumentException(sprintf('The char property can only contain items of int, "%s" given', is_object($arrayOfcharCharItem) ? get_class($arrayOfcharCharItem) : gettype($arrayOfcharCharItem)), __LINE__);
            }
        }
        $this->char = $char;
        return $this;
    }
    /**
     * Add item to char value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \ArrayType\ArrayOfchar
     */
    public function addToChar($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The char property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->char[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return int|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return int|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return int|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return int|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return int|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string char
     */
    public function getAttributeName()
    {
        return 'char';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfchar
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
