<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNullableOfguid ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfNullableOfguid
 * @subpackage Arrays
 */
class ArrayOfNullableOfguid extends AbstractStructArrayBase
{
    /**
     * The guid
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string[]
     */
    public $guid;
    /**
     * Constructor method for ArrayOfNullableOfguid
     * @uses ArrayOfNullableOfguid::setGuid()
     * @param string[] $guid
     */
    public function __construct(array $guid = array())
    {
        $this
            ->setGuid($guid);
    }
    /**
     * Get guid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getGuid()
    {
        return isset($this->guid) ? $this->guid : null;
    }
    /**
     * Set guid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $guid
     * @return \ArrayType\ArrayOfNullableOfguid
     */
    public function setGuid(array $guid = array())
    {
        // validation for constraint: pattern
        if (is_scalar($guid) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($guid, true)), __LINE__);
        }
        foreach ($guid as $arrayOfNullableOfguidGuidItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfNullableOfguidGuidItem)) {
                throw new \InvalidArgumentException(sprintf('The guid property can only contain items of string, "%s" given', is_object($arrayOfNullableOfguidGuidItem) ? get_class($arrayOfNullableOfguidGuidItem) : gettype($arrayOfNullableOfguidGuidItem)), __LINE__);
            }
        }
        if (is_null($guid) || (is_array($guid) && empty($guid))) {
            unset($this->guid);
        } else {
            $this->guid = $guid;
        }
        return $this;
    }
    /**
     * Add item to guid value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfNullableOfguid
     */
    public function addToGuid($item)
    {
        // validation for constraint: pattern
        if (is_scalar($item) && !preg_match('/[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($item, true)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The guid property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->guid[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string guid
     */
    public function getAttributeName()
    {
        return 'guid';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfNullableOfguid
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
