<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfNullableOfbyte ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfNullableOfbyte
 * @subpackage Arrays
 */
class ArrayOfNullableOfbyte extends AbstractStructArrayBase
{
    /**
     * The byte
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $byte;
    /**
     * Constructor method for ArrayOfNullableOfbyte
     * @uses ArrayOfNullableOfbyte::setByte()
     * @param string[] $byte
     */
    public function __construct(array $byte = array())
    {
        $this
            ->setByte($byte);
    }
    /**
     * Get byte value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getByte()
    {
        return isset($this->byte) ? $this->byte : null;
    }
    /**
     * Set byte value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $byte
     * @return \ArrayType\ArrayOfNullableOfbyte
     */
    public function setByte(array $byte = array())
    {
        foreach ($byte as $arrayOfNullableOfbyteByteItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfNullableOfbyteByteItem)) {
                throw new \InvalidArgumentException(sprintf('The byte property can only contain items of byte, "%s" given', is_object($arrayOfNullableOfbyteByteItem) ? get_class($arrayOfNullableOfbyteByteItem) : gettype($arrayOfNullableOfbyteByteItem)), __LINE__);
            }
        }
        if (is_null($byte) || (is_array($byte) && empty($byte))) {
            unset($this->byte);
        } else {
            $this->byte = $byte;
        }
        return $this;
    }
    /**
     * Add item to byte value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfNullableOfbyte
     */
    public function addToByte($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The byte property can only contain items of byte, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->byte[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string byte
     */
    public function getAttributeName()
    {
        return 'byte';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfNullableOfbyte
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
