<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SurveySchema StructType
 * @subpackage Structs
 */
class SurveySchema extends AbstractStructBase
{
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $State;
    /**
     * The SchemaSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SchemaSource;
    /**
     * The ReadFilter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ReadFilter
     */
    public $ReadFilter;
    /**
     * The Root
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Root
     */
    public $Root;
    /**
     * Constructor method for SurveySchema
     * @uses SurveySchema::setState()
     * @uses SurveySchema::setSchemaSource()
     * @uses SurveySchema::setReadFilter()
     * @uses SurveySchema::setRoot()
     * @param string $state
     * @param string $schemaSource
     * @param \StructType\ReadFilter $readFilter
     * @param \StructType\Root $root
     */
    public function __construct($state = null, $schemaSource = null, \StructType\ReadFilter $readFilter = null, \StructType\Root $root = null)
    {
        $this
            ->setState($state)
            ->setSchemaSource($schemaSource)
            ->setReadFilter($readFilter)
            ->setRoot($root);
    }
    /**
     * Get State value
     * @return string
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @uses \EnumType\StateType::valueIsValid()
     * @uses \EnumType\StateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \StructType\SurveySchema
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StateType::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $state, implode(', ', \EnumType\StateType::getValidValues())), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get SchemaSource value
     * @return string
     */
    public function getSchemaSource()
    {
        return $this->SchemaSource;
    }
    /**
     * Set SchemaSource value
     * @uses \EnumType\SchemaSourceType::valueIsValid()
     * @uses \EnumType\SchemaSourceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $schemaSource
     * @return \StructType\SurveySchema
     */
    public function setSchemaSource($schemaSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SchemaSourceType::valueIsValid($schemaSource)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $schemaSource, implode(', ', \EnumType\SchemaSourceType::getValidValues())), __LINE__);
        }
        $this->SchemaSource = $schemaSource;
        return $this;
    }
    /**
     * Get ReadFilter value
     * @return \StructType\ReadFilter|null
     */
    public function getReadFilter()
    {
        return $this->ReadFilter;
    }
    /**
     * Set ReadFilter value
     * @param \StructType\ReadFilter $readFilter
     * @return \StructType\SurveySchema
     */
    public function setReadFilter(\StructType\ReadFilter $readFilter = null)
    {
        $this->ReadFilter = $readFilter;
        return $this;
    }
    /**
     * Get Root value
     * @return \StructType\Root|null
     */
    public function getRoot()
    {
        return $this->Root;
    }
    /**
     * Set Root value
     * @param \StructType\Root $root
     * @return \StructType\SurveySchema
     */
    public function setRoot(\StructType\Root $root = null)
    {
        $this->Root = $root;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SurveySchema
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
