<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetDatabaseLastCompiled operation/method
 */
if ($get->GetDatabaseLastCompiled(new \StructType\GetDatabaseLastCompiled()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProjectList operation/method
 */
if ($get->GetProjectList(new \StructType\GetProjectList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProjectListByProjectName operation/method
 */
if ($get->GetProjectListByProjectName(new \StructType\GetProjectListByProjectName()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProjectListByCreator operation/method
 */
if ($get->GetProjectListByCreator(new \StructType\GetProjectListByCreator()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProjectListByKeywords operation/method
 */
if ($get->GetProjectListByKeywords(new \StructType\GetProjectListByKeywords()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProjectListByCreatedDate operation/method
 */
if ($get->GetProjectListByCreatedDate(new \StructType\GetProjectListByCreatedDate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomProjectInfoField operation/method
 */
if ($get->GetCustomProjectInfoField(new \StructType\GetCustomProjectInfoField()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProjectInfo operation/method
 */
if ($get->GetProjectInfo(new \StructType\GetProjectInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetQuestionnaire operation/method
 */
if ($get->GetQuestionnaire(new \StructType\GetQuestionnaire()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFilteredQuestionnaire operation/method
 */
if ($get->GetFilteredQuestionnaire(new \StructType\GetFilteredQuestionnaire()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPredefinedLists operation/method
 */
if ($get->GetPredefinedLists(new \StructType\GetPredefinedLists()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPredefinedList operation/method
 */
if ($get->GetPredefinedList(new \StructType\GetPredefinedList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetQuotas operation/method
 */
if ($get->GetQuotas(new \StructType\GetQuotas()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetQuota operation/method
 */
if ($get->GetQuota(new \StructType\GetQuota()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFormByName operation/method
 */
if ($get->GetFormByName(new \StructType\GetFormByName()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetForm operation/method
 */
if ($get->GetForm(new \StructType\GetForm()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetNode operation/method
 */
if ($get->GetNode(new \StructType\GetNode()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetNodes operation/method
 */
if ($get->GetNodes(new \StructType\GetNodes()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFormsInLoop operation/method
 */
if ($get->GetFormsInLoop(new \StructType\GetFormsInLoop()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLoopStructure operation/method
 */
if ($get->GetLoopStructure(new \StructType\GetLoopStructure()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetConditionBranch operation/method
 */
if ($get->GetConditionBranch(new \StructType\GetConditionBranch()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetRouting operation/method
 */
if ($get->GetRouting(new \StructType\GetRouting()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSurveyStatus operation/method
 */
if ($get->GetSurveyStatus(new \StructType\GetSurveyStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetExternalAnswers operation/method
 */
if ($get->GetExternalAnswers(new \StructType\GetExternalAnswers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetBenchmarkProjectIds operation/method
 */
if ($get->GetBenchmarkProjectIds(new \StructType\GetBenchmarkProjectIds()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetProjectEmailObjects operation/method
 */
if ($get->GetProjectEmailObjects(new \StructType\GetProjectEmailObjects()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for AddProjectFromTripleS operation/method
 */
if ($add->AddProjectFromTripleS(new \StructType\AddProjectFromTripleS()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for AddProject operation/method
 */
if ($add->AddProject(new \StructType\AddProject()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for DeleteProject operation/method
 */
if ($delete->DeleteProject(new \StructType\DeleteProject()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteRouting operation/method
 */
if ($delete->DeleteRouting(new \StructType\DeleteRouting()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteQuestionnaire operation/method
 */
if ($delete->DeleteQuestionnaire(new \StructType\DeleteQuestionnaire()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Duplicate ServiceType
 */
$duplicate = new \ServiceType\Duplicate($options);
/**
 * Sample call for DuplicateProject operation/method
 */
if ($duplicate->DuplicateProject(new \StructType\DuplicateProject()) !== false) {
    print_r($duplicate->getResult());
} else {
    print_r($duplicate->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
/**
 * Sample call for SetCustomProjectInfoField operation/method
 */
if ($set->SetCustomProjectInfoField(new \StructType\SetCustomProjectInfoField()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetSurveyStatus operation/method
 */
if ($set->SetSurveyStatus(new \StructType\SetSurveyStatus()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Export ServiceType
 */
$export = new \ServiceType\Export($options);
/**
 * Sample call for ExportSurvey operation/method
 */
if ($export->ExportSurvey(new \StructType\ExportSurvey()) !== false) {
    print_r($export->getResult());
} else {
    print_r($export->getLastError());
}
/**
 * Sample call for ExportSurveyLayout operation/method
 */
if ($export->ExportSurveyLayout(new \StructType\ExportSurveyLayout()) !== false) {
    print_r($export->getResult());
} else {
    print_r($export->getLastError());
}
/**
 * Sample call for ExportSurveyWithHTMLRemoved operation/method
 */
if ($export->ExportSurveyWithHTMLRemoved(new \StructType\ExportSurveyWithHTMLRemoved()) !== false) {
    print_r($export->getResult());
} else {
    print_r($export->getLastError());
}
/**
 * Sample call for ExportTranslation operation/method
 */
if ($export->ExportTranslation(new \StructType\ExportTranslation()) !== false) {
    print_r($export->getResult());
} else {
    print_r($export->getLastError());
}
/**
 * Samples for Import ServiceType
 */
$import = new \ServiceType\Import($options);
/**
 * Sample call for ImportSurvey operation/method
 */
if ($import->ImportSurvey(new \StructType\ImportSurvey()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for ImportTranslation operation/method
 */
if ($import->ImportTranslation(new \StructType\ImportTranslation()) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for Update operation/method
 */
if ($update->Update(new \StructType\Update()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Project ServiceType
 */
$project = new \ServiceType\Project($options);
/**
 * Sample call for ProjectExists operation/method
 */
if ($project->ProjectExists(new \StructType\ProjectExists()) !== false) {
    print_r($project->getResult());
} else {
    print_r($project->getLastError());
}
