<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Stop StructType
 * @subpackage Structs
 */
class Stop extends QuestionnaireNode
{
    /**
     * The StopType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $StopType;
    /**
     * The ITS
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $ITS;
    /**
     * The ExcludeTranslation
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $ExcludeTranslation;
    /**
     * The PageMasterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PageMasterName;
    /**
     * The CompleteTexts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfLanguageString
     */
    public $CompleteTexts;
    /**
     * The CompleteTitles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfLanguageString1
     */
    public $CompleteTitles;
    /**
     * The TranslationStatuses
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTranslationStatus
     */
    public $TranslationStatuses;
    /**
     * Constructor method for Stop
     * @uses Stop::setStopType()
     * @uses Stop::setITS()
     * @uses Stop::setExcludeTranslation()
     * @uses Stop::setPageMasterName()
     * @uses Stop::setCompleteTexts()
     * @uses Stop::setCompleteTitles()
     * @uses Stop::setTranslationStatuses()
     * @param string $stopType
     * @param int $iTS
     * @param bool $excludeTranslation
     * @param string $pageMasterName
     * @param \ArrayType\ArrayOfLanguageString $completeTexts
     * @param \ArrayType\ArrayOfLanguageString1 $completeTitles
     * @param \ArrayType\ArrayOfTranslationStatus $translationStatuses
     */
    public function __construct($stopType = null, $iTS = null, $excludeTranslation = null, $pageMasterName = null, \ArrayType\ArrayOfLanguageString $completeTexts = null, \ArrayType\ArrayOfLanguageString1 $completeTitles = null, \ArrayType\ArrayOfTranslationStatus $translationStatuses = null)
    {
        $this
            ->setStopType($stopType)
            ->setITS($iTS)
            ->setExcludeTranslation($excludeTranslation)
            ->setPageMasterName($pageMasterName)
            ->setCompleteTexts($completeTexts)
            ->setCompleteTitles($completeTitles)
            ->setTranslationStatuses($translationStatuses);
    }
    /**
     * Get StopType value
     * @return string
     */
    public function getStopType()
    {
        return $this->StopType;
    }
    /**
     * Set StopType value
     * @uses \EnumType\StopDataType::valueIsValid()
     * @uses \EnumType\StopDataType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stopType
     * @return \StructType\Stop
     */
    public function setStopType($stopType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StopDataType::valueIsValid($stopType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $stopType, implode(', ', \EnumType\StopDataType::getValidValues())), __LINE__);
        }
        $this->StopType = $stopType;
        return $this;
    }
    /**
     * Get ITS value
     * @return int
     */
    public function getITS()
    {
        return $this->ITS;
    }
    /**
     * Set ITS value
     * @param int $iTS
     * @return \StructType\Stop
     */
    public function setITS($iTS = null)
    {
        // validation for constraint: int
        if (!is_null($iTS) && !is_numeric($iTS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iTS)), __LINE__);
        }
        $this->ITS = $iTS;
        return $this;
    }
    /**
     * Get ExcludeTranslation value
     * @return bool
     */
    public function getExcludeTranslation()
    {
        return $this->ExcludeTranslation;
    }
    /**
     * Set ExcludeTranslation value
     * @param bool $excludeTranslation
     * @return \StructType\Stop
     */
    public function setExcludeTranslation($excludeTranslation = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeTranslation) && !is_bool($excludeTranslation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($excludeTranslation)), __LINE__);
        }
        $this->ExcludeTranslation = $excludeTranslation;
        return $this;
    }
    /**
     * Get PageMasterName value
     * @return string|null
     */
    public function getPageMasterName()
    {
        return $this->PageMasterName;
    }
    /**
     * Set PageMasterName value
     * @param string $pageMasterName
     * @return \StructType\Stop
     */
    public function setPageMasterName($pageMasterName = null)
    {
        // validation for constraint: string
        if (!is_null($pageMasterName) && !is_string($pageMasterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pageMasterName)), __LINE__);
        }
        $this->PageMasterName = $pageMasterName;
        return $this;
    }
    /**
     * Get CompleteTexts value
     * @return \ArrayType\ArrayOfLanguageString|null
     */
    public function getCompleteTexts()
    {
        return $this->CompleteTexts;
    }
    /**
     * Set CompleteTexts value
     * @param \ArrayType\ArrayOfLanguageString $completeTexts
     * @return \StructType\Stop
     */
    public function setCompleteTexts(\ArrayType\ArrayOfLanguageString $completeTexts = null)
    {
        $this->CompleteTexts = $completeTexts;
        return $this;
    }
    /**
     * Get CompleteTitles value
     * @return \ArrayType\ArrayOfLanguageString1|null
     */
    public function getCompleteTitles()
    {
        return $this->CompleteTitles;
    }
    /**
     * Set CompleteTitles value
     * @param \ArrayType\ArrayOfLanguageString1 $completeTitles
     * @return \StructType\Stop
     */
    public function setCompleteTitles(\ArrayType\ArrayOfLanguageString1 $completeTitles = null)
    {
        $this->CompleteTitles = $completeTitles;
        return $this;
    }
    /**
     * Get TranslationStatuses value
     * @return \ArrayType\ArrayOfTranslationStatus|null
     */
    public function getTranslationStatuses()
    {
        return $this->TranslationStatuses;
    }
    /**
     * Set TranslationStatuses value
     * @param \ArrayType\ArrayOfTranslationStatus $translationStatuses
     * @return \StructType\Stop
     */
    public function setTranslationStatuses(\ArrayType\ArrayOfTranslationStatus $translationStatuses = null)
    {
        $this->TranslationStatuses = $translationStatuses;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Stop
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
