<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Questionnaire StructType
 * @subpackage Structs
 */
class Questionnaire extends Node
{
    /**
     * The ProjectInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProjectInfo
     */
    public $ProjectInfo;
    /**
     * The PredefinedLists
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPredefinedList
     */
    public $PredefinedLists;
    /**
     * The Emails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEmail
     */
    public $Emails;
    /**
     * The Routing
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ArrayOfChoice16
     */
    public $Routing;
    /**
     * The Blocks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfBlock
     */
    public $Blocks;
    /**
     * The Quotas
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfQuota
     */
    public $Quotas;
    /**
     * Constructor method for Questionnaire
     * @uses Questionnaire::setProjectInfo()
     * @uses Questionnaire::setPredefinedLists()
     * @uses Questionnaire::setEmails()
     * @uses Questionnaire::setRouting()
     * @uses Questionnaire::setBlocks()
     * @uses Questionnaire::setQuotas()
     * @param \StructType\ProjectInfo $projectInfo
     * @param \ArrayType\ArrayOfPredefinedList $predefinedLists
     * @param \ArrayType\ArrayOfEmail $emails
     * @param \StructType\ArrayOfChoice16 $routing
     * @param \ArrayType\ArrayOfBlock $blocks
     * @param \ArrayType\ArrayOfQuota $quotas
     */
    public function __construct(\StructType\ProjectInfo $projectInfo = null, \ArrayType\ArrayOfPredefinedList $predefinedLists = null, \ArrayType\ArrayOfEmail $emails = null, \StructType\ArrayOfChoice16 $routing = null, \ArrayType\ArrayOfBlock $blocks = null, \ArrayType\ArrayOfQuota $quotas = null)
    {
        $this
            ->setProjectInfo($projectInfo)
            ->setPredefinedLists($predefinedLists)
            ->setEmails($emails)
            ->setRouting($routing)
            ->setBlocks($blocks)
            ->setQuotas($quotas);
    }
    /**
     * Get ProjectInfo value
     * @return \StructType\ProjectInfo|null
     */
    public function getProjectInfo()
    {
        return $this->ProjectInfo;
    }
    /**
     * Set ProjectInfo value
     * @param \StructType\ProjectInfo $projectInfo
     * @return \StructType\Questionnaire
     */
    public function setProjectInfo(\StructType\ProjectInfo $projectInfo = null)
    {
        $this->ProjectInfo = $projectInfo;
        return $this;
    }
    /**
     * Get PredefinedLists value
     * @return \ArrayType\ArrayOfPredefinedList|null
     */
    public function getPredefinedLists()
    {
        return $this->PredefinedLists;
    }
    /**
     * Set PredefinedLists value
     * @param \ArrayType\ArrayOfPredefinedList $predefinedLists
     * @return \StructType\Questionnaire
     */
    public function setPredefinedLists(\ArrayType\ArrayOfPredefinedList $predefinedLists = null)
    {
        $this->PredefinedLists = $predefinedLists;
        return $this;
    }
    /**
     * Get Emails value
     * @return \ArrayType\ArrayOfEmail|null
     */
    public function getEmails()
    {
        return $this->Emails;
    }
    /**
     * Set Emails value
     * @param \ArrayType\ArrayOfEmail $emails
     * @return \StructType\Questionnaire
     */
    public function setEmails(\ArrayType\ArrayOfEmail $emails = null)
    {
        $this->Emails = $emails;
        return $this;
    }
    /**
     * Get Routing value
     * @return \StructType\ArrayOfChoice16|null
     */
    public function getRouting()
    {
        return $this->Routing;
    }
    /**
     * Set Routing value
     * @param \StructType\ArrayOfChoice16 $routing
     * @return \StructType\Questionnaire
     */
    public function setRouting(\StructType\ArrayOfChoice16 $routing = null)
    {
        $this->Routing = $routing;
        return $this;
    }
    /**
     * Get Blocks value
     * @return \ArrayType\ArrayOfBlock|null
     */
    public function getBlocks()
    {
        return $this->Blocks;
    }
    /**
     * Set Blocks value
     * @param \ArrayType\ArrayOfBlock $blocks
     * @return \StructType\Questionnaire
     */
    public function setBlocks(\ArrayType\ArrayOfBlock $blocks = null)
    {
        $this->Blocks = $blocks;
        return $this;
    }
    /**
     * Get Quotas value
     * @return \ArrayType\ArrayOfQuota|null
     */
    public function getQuotas()
    {
        return $this->Quotas;
    }
    /**
     * Set Quotas value
     * @param \ArrayType\ArrayOfQuota $quotas
     * @return \StructType\Questionnaire
     */
    public function setQuotas(\ArrayType\ArrayOfQuota $quotas = null)
    {
        $this->Quotas = $quotas;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Questionnaire
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
