<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://idevasys03.uzh.ch/evasys_02/services/soapserver-v71-2152.php?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://idevasys03.uzh.ch/evasys_02/services/soapserver-v71-2152.php?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Request ServiceType
 */
$request = new \ServiceType\Request($options);
/**
 * Sample call for RequestTicket operation/method
 */
if ($request->RequestTicket($Login, $Password) !== false) {
    print_r($request->getResult());
} else {
    print_r($request->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
$get->setSoapHeaderHeader(new \StructType\Header());
/**
 * Sample call for GetPswdsByParticipant operation/method
 */
if ($get->GetPswdsByParticipant($UserMailAddress, $CourseCode, $CustomFieldToConsider) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUser operation/method
 */
if ($get->GetUser($UserId, $IdType, $IncludeCourses, $IncludeSurveys, $IncludeParticipants, $IncludeSecondaryCourses) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUsersBySubunit operation/method
 */
if ($get->GetUsersBySubunit($nSubunitId, $IncludeCourses, $IncludeSurveys, $IncludeParticipants, $IncludeSecondaryCourses) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllPeriods operation/method
 */
if ($get->GetAllPeriods() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCoursesByUserId operation/method
 */
if ($get->GetCoursesByUserId($nUserId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCourse operation/method
 */
if ($get->GetCourse($CourseId, $IdType, $IncludeSurveys, $IncludeParticipants) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPeriod operation/method
 */
if ($get->GetPeriod($sPeriodId, $sPeriodIdType) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllForms operation/method
 */
if ($get->GetAllForms($IncludeCustomReports, $IncludeUsageRestrictions, new \StructType\UsageRestrictionList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSurveyTypes operation/method
 */
if ($get->GetSurveyTypes() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFormByCourseIdAndPeriodId operation/method
 */
if ($get->GetFormByCourseIdAndPeriodId($nCourseId, $nPeriodId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetForm operation/method
 */
if ($get->GetForm($FormId, $IdType, $IncludeOnlyQuestions, $SkipPoleLabelsInheritance) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSurveyById operation/method
 */
if ($get->GetSurveyById($nSurveyId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSurveysByCourse operation/method
 */
if ($get->GetSurveysByCourse($nCourseId, $nFormId, $nPeriodId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPswdsBySurvey operation/method
 */
if ($get->GetPswdsBySurvey($nSurveyId, $nPswdCount, $nCodeTypes, $bForceNewPasswordGeneration, $bSetPswdsToSent) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPDFReport operation/method
 */
if ($get->GetPDFReport($nSurveyId, $nUserId, $nCustomPDFId, $nLanguageID) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSubunits operation/method
 */
if ($get->GetSubunits() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSubunit operation/method
 */
if ($get->GetSubunit($SubunitId, $IdType, $IncludeInstructors) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPDFPluginsByFormId operation/method
 */
if ($get->GetPDFPluginsByFormId($FormId, $UserId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPDFQuestionnaire operation/method
 */
if ($get->GetPDFQuestionnaire($FormId, $SurveyId, $SerialPrint, $Additionalcopies, $SerialNumberFrom, $SerialNumberTo) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPDFCoversheet operation/method
 */
if ($get->GetPDFCoversheet($SurveyId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPDFPswd operation/method
 */
if ($get->GetPDFPswd($SurveyId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSPSSRawData operation/method
 */
if ($get->GetSPSSRawData($SurveyId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCSVRawData operation/method
 */
if ($get->GetCSVRawData($SurveyId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSurveyRawData operation/method
 */
if ($get->GetSurveyRawData($SurveyId, $IncludeOpenEndedQuestions, new \StructType\IDList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSurveyResults operation/method
 */
if ($get->GetSurveyResults($SurveyId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetOnlineSurveyLinkByEmail operation/method
 */
if ($get->GetOnlineSurveyLinkByEmail($SurveyId, $EmailAddress, $AddRecipientToSurvey, $AutoIncreasePSWDCount) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomReportsByForm operation/method
 */
if ($get->GetCustomReportsByForm($FormId, $IdType) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSimpleForm operation/method
 */
if ($get->GetSimpleForm($FormId, $IdType, $IncludeCustomReports, $IncludeUsageRestrictions) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetVFD operation/method
 */
if ($get->GetVFD($FormId, $IncludeSecondaryData) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSurveyRawDataByTime operation/method
 */
if ($get->GetSurveyRawDataByTime($StartTime, $EndTime, $IncludeOpenEndedQuestions) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSessionForUser operation/method
 */
if ($get->GetSessionForUser($UserId, $IdType) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCourseTypes operation/method
 */
if ($get->GetCourseTypes($OnlyModuleCourseTypes) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPswdsByRecipient operation/method
 */
if ($get->GetPswdsByRecipient($UserMailAddress) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPercentOfCompletedSurveysByParticipant operation/method
 */
if ($get->GetPercentOfCompletedSurveysByParticipant($UserMailAddress, $StartDate, $EndDate, $SubunitId, $IdType) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAccessibleSubunitsForSubunitAdmin operation/method
 */
if ($get->GetAccessibleSubunitsForSubunitAdmin($nUserId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserVolumeLicenses operation/method
 */
if ($get->GetUserVolumeLicenses($UserId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSurveyOriginalScansPDF operation/method
 */
if ($get->GetSurveyOriginalScansPDF($SurveyId, $SheetId, $BatchId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetWebscanBatchList operation/method
 */
if ($get->GetWebscanBatchList($UserId, $Language) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSurveyIDsByParams operation/method
 */
if ($get->GetSurveyIDsByParams(new \StructType\SurveyParams()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFiltersByFormId operation/method
 */
if ($get->GetFiltersByFormId($FormId, $SurveyId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEMailsByIDList operation/method
 */
if ($get->GetEMailsByIDList(new \StructType\IDList(), $Status) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEMailSummaryByCreationDate operation/method
 */
if ($get->GetEMailSummaryByCreationDate($CreationDate) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetVerifierInfoBySurvey operation/method
 */
if ($get->GetVerifierInfoBySurvey($SurveyId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetVerifierInfoBySerialNumber operation/method
 */
if ($get->GetVerifierInfoBySerialNumber($SurveyId, $SerialNumber, $SerialNumberCounter) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetVerifierInfoByParticipant operation/method
 */
if ($get->GetVerifierInfoByParticipant($SurveyId, $ParticipantIdentifier) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetVerifierInfoByBatch operation/method
 */
if ($get->GetVerifierInfoByBatch($BatchId, $BatchIdType, $SurveyId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserSessionInfo operation/method
 */
if ($get->GetUserSessionInfo($SessionId, $ResumeSession) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetConfigurationInfo operation/method
 */
if ($get->GetConfigurationInfo($UserId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserByLogin operation/method
 */
if ($get->GetUserByLogin($Login, $Password) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEvaluationSummaryByParticipant operation/method
 */
if ($get->GetEvaluationSummaryByParticipant($ParticipantMailAddress, $SurveyTypes, $SurveyOpenState) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPdfReportDefinition operation/method
 */
if ($get->GetPdfReportDefinition($PDFReportDefinitionId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPdfReportDefinitionsByFormId operation/method
 */
if ($get->GetPdfReportDefinitionsByFormId($FormId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFormTranslations operation/method
 */
if ($get->GetFormTranslations($FormId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllTextTemplateIDs operation/method
 */
if ($get->GetAllTextTemplateIDs() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTextTemplateById operation/method
 */
if ($get->GetTextTemplateById($TextTemplateId, $FormId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserByIdConsiderExternalID operation/method
 */
if ($get->GetUserByIdConsiderExternalID($UserId, $IdType, $IncludeCourses, $IncludeSurveys, $IncludeParticipants, $IncludeSecondaryCourses) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPswdSummary operation/method
 */
if ($get->GetPswdSummary($Pswd) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFoldersByUserId operation/method
 */
if ($get->GetFoldersByUserId($UserId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllSurveysByFolderId operation/method
 */
if ($get->GetAllSurveysByFolderId($FolderId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetIndicatorsByFormId operation/method
 */
if ($get->GetIndicatorsByFormId($FormId, $SurveyId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomUserSetting operation/method
 */
if ($get->GetCustomUserSetting($SettingKey) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCustomUserSettingsList operation/method
 */
if ($get->GetCustomUserSettingsList() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSurveyNotices operation/method
 */
if ($get->GetSurveyNotices($SurveyId) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetLicenseInformation operation/method
 */
if ($get->GetLicenseInformation() !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFormsInfoByParams operation/method
 */
if ($get->GetFormsInfoByParams(new \StructType\FormParams()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSurveyResponseDistribution operation/method
 */
if ($get->GetSurveyResponseDistribution(new \StructType\IDList(), $OnlineResponses, $GroupBySurveyId, $DataAggregationUnit, $StartTime, $EndTime) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetUserIdsByParams operation/method
 */
if ($get->GetUserIdsByParams(new \StructType\UserParams()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCourseIdsByParams operation/method
 */
if ($get->GetCourseIdsByParams(new \StructType\CourseParams()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReaderScanBatchList operation/method
 */
if ($get->GetReaderScanBatchList(new \StructType\ReaderScanBatchParams()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetParticipationTrackingList operation/method
 */
if ($get->GetParticipationTrackingList(new \StructType\ParticipationTrackingParams()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSurveyResponseRateInformation operation/method
 */
if ($get->GetSurveyResponseRateInformation(new \StructType\IDList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllAvailableTransactionsByUserLogin operation/method
 */
if ($get->GetAllAvailableTransactionsByUserLogin($SoapLoginName) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDataBySQLQuery operation/method
 */
if ($get->GetDataBySQLQuery($Query) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetAllProgramsOfStudy operation/method
 */
if ($get->GetAllProgramsOfStudy(new \StructType\IDList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEntitiesByKeyword operation/method
 */
if ($get->GetEntitiesByKeyword($Keyword, new \StructType\EntityList()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
$delete->setSoapHeaderHeader(new \StructType\Header());
/**
 * Sample call for DeleteUnusedPswds operation/method
 */
if ($delete->DeleteUnusedPswds(new \StructType\OnlineCodeList()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteUser operation/method
 */
if ($delete->DeleteUser($UserId, $IdType) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteCourse operation/method
 */
if ($delete->DeleteCourse($CourseId, $IdType) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteSubunit operation/method
 */
if ($delete->DeleteSubunit($SubunitId, $IdType) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteSurvey operation/method
 */
if ($delete->DeleteSurvey($SurveyId) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteTask operation/method
 */
if ($delete->DeleteTask($TaskId) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteVolumeLicense operation/method
 */
if ($delete->DeleteVolumeLicense($UserId, $LicenseId, $LicenseKey) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteForm operation/method
 */
if ($delete->DeleteForm($FormId) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteCourseType operation/method
 */
if ($delete->DeleteCourseType($CourseTypeId) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteFiltersByFormId operation/method
 */
if ($delete->DeleteFiltersByFormId($FormId, $SurveyId) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteForms operation/method
 */
if ($delete->DeleteForms(new \StructType\IDList()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteCustomUserSetting operation/method
 */
if ($delete->DeleteCustomUserSetting($SettingKey) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for DeleteSurveyNotice operation/method
 */
if ($delete->DeleteSurveyNotice($NoticeId) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
$update->setSoapHeaderHeader(new \StructType\Header());
/**
 * Sample call for UpdateUser operation/method
 */
if ($update->UpdateUser(new \StructType\User()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCourse operation/method
 */
if ($update->UpdateCourse(new \StructType\Course(), $DeleteExistingParticipants) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateSurvey operation/method
 */
if ($update->UpdateSurvey(new \StructType\Survey()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateInvitationTask operation/method
 */
if ($update->UpdateInvitationTask(new \StructType\InvitationTask()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateRemindTask operation/method
 */
if ($update->UpdateRemindTask(new \StructType\RemindTask()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateResponseRateTask operation/method
 */
if ($update->UpdateResponseRateTask(new \StructType\ResponseRateTask()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCloseTask operation/method
 */
if ($update->UpdateCloseTask(new \StructType\CloseTask()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCourseType operation/method
 */
if ($update->UpdateCourseType($CourseTypeId, $Name, $ModuleFormId, $AddConnectionToForms) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateSurveyNotice operation/method
 */
if ($update->UpdateSurveyNotice($NoticeId, $Text, $UpdateDate) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateGroupTitles operation/method
 */
if ($update->UpdateGroupTitles($FormId, $IdType, new \StructType\KeyValueList()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateProfileImage operation/method
 */
if ($update->UpdateProfileImage($UserId, $ProfileImagePath) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Insert ServiceType
 */
$insert = new \ServiceType\Insert($options);
$insert->setSoapHeaderHeader(new \StructType\Header());
/**
 * Sample call for InsertCourse operation/method
 */
if ($insert->InsertCourse(new \StructType\Course()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertCentralSurvey operation/method
 */
if ($insert->InsertCentralSurvey($nUserId, $nCourseId, $nFormId, $nPeriodId, $sSurveyType, $sNotice) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertUser operation/method
 */
if ($insert->InsertUser(new \StructType\User()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertSubunit operation/method
 */
if ($insert->InsertSubunit(new \StructType\Unit()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertCourses operation/method
 */
if ($insert->InsertCourses(new \StructType\CourseCreatorList(), $DeleteExistingParticipants) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertForm operation/method
 */
if ($insert->InsertForm(new \StructType\VFForm()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertParticipants operation/method
 */
if ($insert->InsertParticipants(new \StructType\PersonList(), $CourseId, $IdType, $DeleteExisting) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertSurveyNotice operation/method
 */
if ($insert->InsertSurveyNotice($SurveyId, $Notice, $UserId, $IdType) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertModules operation/method
 */
if ($insert->InsertModules(new \StructType\ModuleList()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertInvitationTask operation/method
 */
if ($insert->InsertInvitationTask(new \StructType\InvitationTask(), new \StructType\PersonList()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertRemindTask operation/method
 */
if ($insert->InsertRemindTask(new \StructType\RemindTask()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertResponseRateTask operation/method
 */
if ($insert->InsertResponseRateTask(new \StructType\ResponseRateTask()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertCloseTask operation/method
 */
if ($insert->InsertCloseTask(new \StructType\CloseTask()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertCourseType operation/method
 */
if ($insert->InsertCourseType($Name, $ModuleFormId, $AddConnectionToForms) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Sample call for InsertSurveyRawData operation/method
 */
if ($insert->InsertSurveyRawData($SurveyId, $StartTime, $EndTime, $UseExportValues, new \StructType\ItemAnswerListList()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Samples for Close ServiceType
 */
$close = new \ServiceType\Close($options);
$close->setSoapHeaderHeader(new \StructType\Header());
/**
 * Sample call for CloseSurvey operation/method
 */
if ($close->CloseSurvey($nSurveyId) !== false) {
    print_r($close->getResult());
} else {
    print_r($close->getLastError());
}
/**
 * Samples for Open ServiceType
 */
$open = new \ServiceType\Open($options);
$open->setSoapHeaderHeader(new \StructType\Header());
/**
 * Sample call for OpenSurvey operation/method
 */
if ($open->OpenSurvey($nSurveyId) !== false) {
    print_r($open->getResult());
} else {
    print_r($open->getLastError());
}
/**
 * Samples for Is ServiceType
 */
$is = new \ServiceType\Is($options);
$is->setSoapHeaderHeader(new \StructType\Header());
/**
 * Sample call for IsPswdUnused operation/method
 */
if ($is->IsPswdUnused($sPSWD) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Samples for Setup ServiceType
 */
$setup = new \ServiceType\Setup($options);
$setup->setSoapHeaderHeader(new \StructType\Header());
/**
 * Sample call for SetupCentralSurvey operation/method
 */
if ($setup->SetupCentralSurvey(new \StructType\User(), new \StructType\Course(), new \StructType\Unit(), $nFormId, $nPeriodId, $sSurveyType, $sNotice) !== false) {
    print_r($setup->getResult());
} else {
    print_r($setup->getLastError());
}
/**
 * Samples for Activate ServiceType
 */
$activate = new \ServiceType\Activate($options);
$activate->setSoapHeaderHeader(new \StructType\Header());
/**
 * Sample call for ActivateOptionalQuestionsForSurvey operation/method
 */
if ($activate->ActivateOptionalQuestionsForSurvey($SurveyId, $SendEmail, $Mode) !== false) {
    print_r($activate->getResult());
} else {
    print_r($activate->getLastError());
}
/**
 * Sample call for ActivateOptionalQuestionsForSurveys operation/method
 */
if ($activate->ActivateOptionalQuestionsForSurveys(new \StructType\IDList(), $SendEmail, $Mode) !== false) {
    print_r($activate->getResult());
} else {
    print_r($activate->getLastError());
}
/**
 * Sample call for ActivateOptionalQuestionsForSurveyAddQuestions operation/method
 */
if ($activate->ActivateOptionalQuestionsForSurveyAddQuestions($SurveyId, new \StructType\ItemGroupList()) !== false) {
    print_r($activate->getResult());
} else {
    print_r($activate->getLastError());
}
/**
 * Samples for List ServiceType
 */
$list = new \ServiceType\_List($options);
$list->setSoapHeaderHeader(new \StructType\Header());
/**
 * Sample call for ListTasks operation/method
 */
if ($list->ListTasks(new \StructType\IDList(), new \StructType\IDList(), new \StructType\IDList(), new \StructType\IDList(), new \StructType\IDList()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
$create->setSoapHeaderHeader(new \StructType\Header());
/**
 * Sample call for CreatePdfReportDefinition operation/method
 */
if ($create->CreatePdfReportDefinition(new \StructType\PDFReportDefinition(), $PDFReportDefinitionCreationMode) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Upload ServiceType
 */
$upload = new \ServiceType\Upload($options);
$upload->setSoapHeaderHeader(new \StructType\Header());
/**
 * Sample call for UploadVolumeLicense operation/method
 */
if ($upload->UploadVolumeLicense($UserId, $LicenseKey) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Samples for Replace ServiceType
 */
$replace = new \ServiceType\Replace($options);
$replace->setSoapHeaderHeader(new \StructType\Header());
/**
 * Sample call for ReplaceAnswersToOpenQuestions operation/method
 */
if ($replace->ReplaceAnswersToOpenQuestions(new \StructType\IDList(), new \StructType\StringList(), $sReplaceComment) !== false) {
    print_r($replace->getResult());
} else {
    print_r($replace->getLastError());
}
/**
 * Samples for Apply ServiceType
 */
$apply = new \ServiceType\Apply($options);
$apply->setSoapHeaderHeader(new \StructType\Header());
/**
 * Sample call for ApplyActionOnWebscanBatch operation/method
 */
if ($apply->ApplyActionOnWebscanBatch($BatchId, $Action) !== false) {
    print_r($apply->getResult());
} else {
    print_r($apply->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \ServiceType\Set($options);
$set->setSoapHeaderHeader(new \StructType\Header());
/**
 * Sample call for SetFormActivationStatus operation/method
 */
if ($set->SetFormActivationStatus($FormId, $ActivationStatus) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetFiltersForForm operation/method
 */
if ($set->SetFiltersForForm($FormId, $SurveyId, new \StructType\FilterSetList()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetFormUsageRestrictions operation/method
 */
if ($set->SetFormUsageRestrictions($FormId, new \StructType\UsageRestrictionList()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetFormTranslations operation/method
 */
if ($set->SetFormTranslations(new \StructType\FormTranslationList()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetFormMainLanguage operation/method
 */
if ($set->SetFormMainLanguage(new \StructType\FormMainLanguage()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetFormProperties operation/method
 */
if ($set->SetFormProperties(new \StructType\FormProperties()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetUserPassword operation/method
 */
if ($set->SetUserPassword($Login, $Password) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Sample call for SetGlobalConfiguration operation/method
 */
if ($set->SetGlobalConfiguration(new \StructType\KeyValueList()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Reset ServiceType
 */
$reset = new \ServiceType\Reset($options);
$reset->setSoapHeaderHeader(new \StructType\Header());
/**
 * Sample call for ResetSurvey operation/method
 */
if ($reset->ResetSurvey($SurveyId) !== false) {
    print_r($reset->getResult());
} else {
    print_r($reset->getLastError());
}
/**
 * Samples for Prefill ServiceType
 */
$prefill = new \ServiceType\Prefill($options);
$prefill->setSoapHeaderHeader(new \StructType\Header());
/**
 * Sample call for PrefillDataIntoOnlineSurvey operation/method
 */
if ($prefill->PrefillDataIntoOnlineSurvey($SurveyId, new \StructType\KeyValueList(), new \StructType\StringList()) !== false) {
    print_r($prefill->getResult());
} else {
    print_r($prefill->getLastError());
}
/**
 * Samples for Assign ServiceType
 */
$assign = new \ServiceType\Assign($options);
$assign->setSoapHeaderHeader(new \StructType\Header());
/**
 * Sample call for AssignVolumeToSubunit operation/method
 */
if ($assign->AssignVolumeToSubunit($SubunitId, $Volume) !== false) {
    print_r($assign->getResult());
} else {
    print_r($assign->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
$add->setSoapHeaderHeader(new \StructType\Header());
/**
 * Sample call for AddEMailsToQueue operation/method
 */
if ($add->AddEMailsToQueue(new \StructType\MailList()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Save ServiceType
 */
$save = new \ServiceType\Save($options);
$save->setSoapHeaderHeader(new \StructType\Header());
/**
 * Sample call for SaveCustomUserSetting operation/method
 */
if ($save->SaveCustomUserSetting($SettingKey, $SettingValue) !== false) {
    print_r($save->getResult());
} else {
    print_r($save->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
$send->setSoapHeaderHeader(new \StructType\Header());
/**
 * Sample call for SendInvitationToParticipants operation/method
 */
if ($send->SendInvitationToParticipants($SurveyId, $IsReminder, $ProgressIdPrefix) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Move ServiceType
 */
$move = new \ServiceType\Move($options);
$move->setSoapHeaderHeader(new \StructType\Header());
/**
 * Sample call for MoveSurveyToSubstituteUser operation/method
 */
if ($move->MoveSurveyToSubstituteUser($SurveyID, $SubstituteUserID, $SendReport, $MoveCourse) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Sample call for MoveUser operation/method
 */
if ($move->MoveUser($UserID, $TargetSubunitID, $OverwriteSimilarUser) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
