<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerifierSurvey StructType
 * @subpackage Structs
 */
class VerifierSurvey extends AbstractStructBase
{
    /**
     * The SurveyId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SurveyId;
    /**
     * The VerifierBatchs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\VerifierBatchList
     */
    public $VerifierBatchs;
    /**
     * Constructor method for VerifierSurvey
     * @uses VerifierSurvey::setSurveyId()
     * @uses VerifierSurvey::setVerifierBatchs()
     * @param int $surveyId
     * @param \StructType\VerifierBatchList $verifierBatchs
     */
    public function __construct($surveyId = null, \StructType\VerifierBatchList $verifierBatchs = null)
    {
        $this
            ->setSurveyId($surveyId)
            ->setVerifierBatchs($verifierBatchs);
    }
    /**
     * Get SurveyId value
     * @return int
     */
    public function getSurveyId()
    {
        return $this->SurveyId;
    }
    /**
     * Set SurveyId value
     * @param int $surveyId
     * @return \StructType\VerifierSurvey
     */
    public function setSurveyId($surveyId = null)
    {
        // validation for constraint: int
        if (!is_null($surveyId) && !is_numeric($surveyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($surveyId)), __LINE__);
        }
        $this->SurveyId = $surveyId;
        return $this;
    }
    /**
     * Get VerifierBatchs value
     * @return \StructType\VerifierBatchList
     */
    public function getVerifierBatchs()
    {
        return $this->VerifierBatchs;
    }
    /**
     * Set VerifierBatchs value
     * @param \StructType\VerifierBatchList $verifierBatchs
     * @return \StructType\VerifierSurvey
     */
    public function setVerifierBatchs(\StructType\VerifierBatchList $verifierBatchs = null)
    {
        $this->VerifierBatchs = $verifierBatchs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VerifierSurvey
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
