<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerifierSheet StructType
 * @subpackage Structs
 */
class VerifierSheet extends AbstractStructBase
{
    /**
     * The SheetId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SheetId;
    /**
     * The BatchId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BatchId;
    /**
     * The SheetNumberInBatch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SheetNumberInBatch;
    /**
     * The SurveyId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SurveyId;
    /**
     * The FormId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FormId;
    /**
     * The PageId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageId;
    /**
     * The SerialNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SerialNumber;
    /**
     * The SerialNumberCounter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SerialNumberCounter;
    /**
     * The ParticipantEmail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ParticipantEmail;
    /**
     * The ParticipantIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ParticipantIdentifier;
    /**
     * The CoverSheet
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $CoverSheet;
    /**
     * The NonFormType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NonFormType;
    /**
     * The SheetImage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SheetImage;
    /**
     * The VerifierQuestions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\VerifierQuestionList
     */
    public $VerifierQuestions;
    /**
     * Constructor method for VerifierSheet
     * @uses VerifierSheet::setSheetId()
     * @uses VerifierSheet::setBatchId()
     * @uses VerifierSheet::setSheetNumberInBatch()
     * @uses VerifierSheet::setSurveyId()
     * @uses VerifierSheet::setFormId()
     * @uses VerifierSheet::setPageId()
     * @uses VerifierSheet::setSerialNumber()
     * @uses VerifierSheet::setSerialNumberCounter()
     * @uses VerifierSheet::setParticipantEmail()
     * @uses VerifierSheet::setParticipantIdentifier()
     * @uses VerifierSheet::setCoverSheet()
     * @uses VerifierSheet::setNonFormType()
     * @uses VerifierSheet::setSheetImage()
     * @uses VerifierSheet::setVerifierQuestions()
     * @param int $sheetId
     * @param int $batchId
     * @param int $sheetNumberInBatch
     * @param int $surveyId
     * @param int $formId
     * @param int $pageId
     * @param int $serialNumber
     * @param int $serialNumberCounter
     * @param string $participantEmail
     * @param string $participantIdentifier
     * @param bool $coverSheet
     * @param int $nonFormType
     * @param string $sheetImage
     * @param \StructType\VerifierQuestionList $verifierQuestions
     */
    public function __construct($sheetId = null, $batchId = null, $sheetNumberInBatch = null, $surveyId = null, $formId = null, $pageId = null, $serialNumber = null, $serialNumberCounter = null, $participantEmail = null, $participantIdentifier = null, $coverSheet = null, $nonFormType = null, $sheetImage = null, \StructType\VerifierQuestionList $verifierQuestions = null)
    {
        $this
            ->setSheetId($sheetId)
            ->setBatchId($batchId)
            ->setSheetNumberInBatch($sheetNumberInBatch)
            ->setSurveyId($surveyId)
            ->setFormId($formId)
            ->setPageId($pageId)
            ->setSerialNumber($serialNumber)
            ->setSerialNumberCounter($serialNumberCounter)
            ->setParticipantEmail($participantEmail)
            ->setParticipantIdentifier($participantIdentifier)
            ->setCoverSheet($coverSheet)
            ->setNonFormType($nonFormType)
            ->setSheetImage($sheetImage)
            ->setVerifierQuestions($verifierQuestions);
    }
    /**
     * Get SheetId value
     * @return int
     */
    public function getSheetId()
    {
        return $this->SheetId;
    }
    /**
     * Set SheetId value
     * @param int $sheetId
     * @return \StructType\VerifierSheet
     */
    public function setSheetId($sheetId = null)
    {
        // validation for constraint: int
        if (!is_null($sheetId) && !is_numeric($sheetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sheetId)), __LINE__);
        }
        $this->SheetId = $sheetId;
        return $this;
    }
    /**
     * Get BatchId value
     * @return int
     */
    public function getBatchId()
    {
        return $this->BatchId;
    }
    /**
     * Set BatchId value
     * @param int $batchId
     * @return \StructType\VerifierSheet
     */
    public function setBatchId($batchId = null)
    {
        // validation for constraint: int
        if (!is_null($batchId) && !is_numeric($batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($batchId)), __LINE__);
        }
        $this->BatchId = $batchId;
        return $this;
    }
    /**
     * Get SheetNumberInBatch value
     * @return int
     */
    public function getSheetNumberInBatch()
    {
        return $this->SheetNumberInBatch;
    }
    /**
     * Set SheetNumberInBatch value
     * @param int $sheetNumberInBatch
     * @return \StructType\VerifierSheet
     */
    public function setSheetNumberInBatch($sheetNumberInBatch = null)
    {
        // validation for constraint: int
        if (!is_null($sheetNumberInBatch) && !is_numeric($sheetNumberInBatch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sheetNumberInBatch)), __LINE__);
        }
        $this->SheetNumberInBatch = $sheetNumberInBatch;
        return $this;
    }
    /**
     * Get SurveyId value
     * @return int
     */
    public function getSurveyId()
    {
        return $this->SurveyId;
    }
    /**
     * Set SurveyId value
     * @param int $surveyId
     * @return \StructType\VerifierSheet
     */
    public function setSurveyId($surveyId = null)
    {
        // validation for constraint: int
        if (!is_null($surveyId) && !is_numeric($surveyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($surveyId)), __LINE__);
        }
        $this->SurveyId = $surveyId;
        return $this;
    }
    /**
     * Get FormId value
     * @return int
     */
    public function getFormId()
    {
        return $this->FormId;
    }
    /**
     * Set FormId value
     * @param int $formId
     * @return \StructType\VerifierSheet
     */
    public function setFormId($formId = null)
    {
        // validation for constraint: int
        if (!is_null($formId) && !is_numeric($formId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($formId)), __LINE__);
        }
        $this->FormId = $formId;
        return $this;
    }
    /**
     * Get PageId value
     * @return int
     */
    public function getPageId()
    {
        return $this->PageId;
    }
    /**
     * Set PageId value
     * @param int $pageId
     * @return \StructType\VerifierSheet
     */
    public function setPageId($pageId = null)
    {
        // validation for constraint: int
        if (!is_null($pageId) && !is_numeric($pageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pageId)), __LINE__);
        }
        $this->PageId = $pageId;
        return $this;
    }
    /**
     * Get SerialNumber value
     * @return int
     */
    public function getSerialNumber()
    {
        return $this->SerialNumber;
    }
    /**
     * Set SerialNumber value
     * @param int $serialNumber
     * @return \StructType\VerifierSheet
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: int
        if (!is_null($serialNumber) && !is_numeric($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serialNumber)), __LINE__);
        }
        $this->SerialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get SerialNumberCounter value
     * @return int
     */
    public function getSerialNumberCounter()
    {
        return $this->SerialNumberCounter;
    }
    /**
     * Set SerialNumberCounter value
     * @param int $serialNumberCounter
     * @return \StructType\VerifierSheet
     */
    public function setSerialNumberCounter($serialNumberCounter = null)
    {
        // validation for constraint: int
        if (!is_null($serialNumberCounter) && !is_numeric($serialNumberCounter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serialNumberCounter)), __LINE__);
        }
        $this->SerialNumberCounter = $serialNumberCounter;
        return $this;
    }
    /**
     * Get ParticipantEmail value
     * @return string
     */
    public function getParticipantEmail()
    {
        return $this->ParticipantEmail;
    }
    /**
     * Set ParticipantEmail value
     * @param string $participantEmail
     * @return \StructType\VerifierSheet
     */
    public function setParticipantEmail($participantEmail = null)
    {
        // validation for constraint: string
        if (!is_null($participantEmail) && !is_string($participantEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($participantEmail)), __LINE__);
        }
        $this->ParticipantEmail = $participantEmail;
        return $this;
    }
    /**
     * Get ParticipantIdentifier value
     * @return string
     */
    public function getParticipantIdentifier()
    {
        return $this->ParticipantIdentifier;
    }
    /**
     * Set ParticipantIdentifier value
     * @param string $participantIdentifier
     * @return \StructType\VerifierSheet
     */
    public function setParticipantIdentifier($participantIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($participantIdentifier) && !is_string($participantIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($participantIdentifier)), __LINE__);
        }
        $this->ParticipantIdentifier = $participantIdentifier;
        return $this;
    }
    /**
     * Get CoverSheet value
     * @return bool
     */
    public function getCoverSheet()
    {
        return $this->CoverSheet;
    }
    /**
     * Set CoverSheet value
     * @param bool $coverSheet
     * @return \StructType\VerifierSheet
     */
    public function setCoverSheet($coverSheet = null)
    {
        // validation for constraint: boolean
        if (!is_null($coverSheet) && !is_bool($coverSheet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($coverSheet)), __LINE__);
        }
        $this->CoverSheet = $coverSheet;
        return $this;
    }
    /**
     * Get NonFormType value
     * @return int
     */
    public function getNonFormType()
    {
        return $this->NonFormType;
    }
    /**
     * Set NonFormType value
     * @param int $nonFormType
     * @return \StructType\VerifierSheet
     */
    public function setNonFormType($nonFormType = null)
    {
        // validation for constraint: int
        if (!is_null($nonFormType) && !is_numeric($nonFormType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nonFormType)), __LINE__);
        }
        $this->NonFormType = $nonFormType;
        return $this;
    }
    /**
     * Get SheetImage value
     * @return string
     */
    public function getSheetImage()
    {
        return $this->SheetImage;
    }
    /**
     * Set SheetImage value
     * @param string $sheetImage
     * @return \StructType\VerifierSheet
     */
    public function setSheetImage($sheetImage = null)
    {
        // validation for constraint: string
        if (!is_null($sheetImage) && !is_string($sheetImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sheetImage)), __LINE__);
        }
        $this->SheetImage = $sheetImage;
        return $this;
    }
    /**
     * Get VerifierQuestions value
     * @return \StructType\VerifierQuestionList
     */
    public function getVerifierQuestions()
    {
        return $this->VerifierQuestions;
    }
    /**
     * Set VerifierQuestions value
     * @param \StructType\VerifierQuestionList $verifierQuestions
     * @return \StructType\VerifierSheet
     */
    public function setVerifierQuestions(\StructType\VerifierQuestionList $verifierQuestions = null)
    {
        $this->VerifierQuestions = $verifierQuestions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VerifierSheet
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
