<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerifierQuestionAnswer StructType
 * @subpackage Structs
 */
class VerifierQuestionAnswer extends AbstractStructBase
{
    /**
     * The AnswerOptionValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $AnswerOptionValue;
    /**
     * The AnswerOptionFillingGrade
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AnswerOptionFillingGrade;
    /**
     * The AnswerPosition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AnswerPosition;
    /**
     * The x
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $x;
    /**
     * The y
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $y;
    /**
     * Constructor method for VerifierQuestionAnswer
     * @uses VerifierQuestionAnswer::setAnswerOptionValue()
     * @uses VerifierQuestionAnswer::setAnswerOptionFillingGrade()
     * @uses VerifierQuestionAnswer::setAnswerPosition()
     * @uses VerifierQuestionAnswer::setX()
     * @uses VerifierQuestionAnswer::setY()
     * @param string $answerOptionValue
     * @param float $answerOptionFillingGrade
     * @param int $answerPosition
     * @param int $x
     * @param int $y
     */
    public function __construct($answerOptionValue = null, $answerOptionFillingGrade = null, $answerPosition = null, $x = null, $y = null)
    {
        $this
            ->setAnswerOptionValue($answerOptionValue)
            ->setAnswerOptionFillingGrade($answerOptionFillingGrade)
            ->setAnswerPosition($answerPosition)
            ->setX($x)
            ->setY($y);
    }
    /**
     * Get AnswerOptionValue value
     * @return string
     */
    public function getAnswerOptionValue()
    {
        return $this->AnswerOptionValue;
    }
    /**
     * Set AnswerOptionValue value
     * @param string $answerOptionValue
     * @return \StructType\VerifierQuestionAnswer
     */
    public function setAnswerOptionValue($answerOptionValue = null)
    {
        // validation for constraint: string
        if (!is_null($answerOptionValue) && !is_string($answerOptionValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($answerOptionValue)), __LINE__);
        }
        $this->AnswerOptionValue = $answerOptionValue;
        return $this;
    }
    /**
     * Get AnswerOptionFillingGrade value
     * @return float
     */
    public function getAnswerOptionFillingGrade()
    {
        return $this->AnswerOptionFillingGrade;
    }
    /**
     * Set AnswerOptionFillingGrade value
     * @param float $answerOptionFillingGrade
     * @return \StructType\VerifierQuestionAnswer
     */
    public function setAnswerOptionFillingGrade($answerOptionFillingGrade = null)
    {
        $this->AnswerOptionFillingGrade = $answerOptionFillingGrade;
        return $this;
    }
    /**
     * Get AnswerPosition value
     * @return int
     */
    public function getAnswerPosition()
    {
        return $this->AnswerPosition;
    }
    /**
     * Set AnswerPosition value
     * @param int $answerPosition
     * @return \StructType\VerifierQuestionAnswer
     */
    public function setAnswerPosition($answerPosition = null)
    {
        // validation for constraint: int
        if (!is_null($answerPosition) && !is_numeric($answerPosition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($answerPosition)), __LINE__);
        }
        $this->AnswerPosition = $answerPosition;
        return $this;
    }
    /**
     * Get x value
     * @return int
     */
    public function getX()
    {
        return $this->x;
    }
    /**
     * Set x value
     * @param int $x
     * @return \StructType\VerifierQuestionAnswer
     */
    public function setX($x = null)
    {
        // validation for constraint: int
        if (!is_null($x) && !is_numeric($x)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($x)), __LINE__);
        }
        $this->x = $x;
        return $this;
    }
    /**
     * Get y value
     * @return int
     */
    public function getY()
    {
        return $this->y;
    }
    /**
     * Set y value
     * @param int $y
     * @return \StructType\VerifierQuestionAnswer
     */
    public function setY($y = null)
    {
        // validation for constraint: int
        if (!is_null($y) && !is_numeric($y)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($y)), __LINE__);
        }
        $this->y = $y;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VerifierQuestionAnswer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
