<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerifierQuestion StructType
 * @subpackage Structs
 */
class VerifierQuestion extends AbstractStructBase
{
    /**
     * The QuestionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QuestionId;
    /**
     * The SheetId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SheetId;
    /**
     * The QuestionType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QuestionType;
    /**
     * The QuestionPosition
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QuestionPosition;
    /**
     * The DataType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DataType;
    /**
     * The QuestionCoord
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Coord
     */
    public $QuestionCoord;
    /**
     * The VerifierQuestionAnswers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\VerifierQuestionAnswerList
     */
    public $VerifierQuestionAnswers;
    /**
     * Constructor method for VerifierQuestion
     * @uses VerifierQuestion::setQuestionId()
     * @uses VerifierQuestion::setSheetId()
     * @uses VerifierQuestion::setQuestionType()
     * @uses VerifierQuestion::setQuestionPosition()
     * @uses VerifierQuestion::setDataType()
     * @uses VerifierQuestion::setQuestionCoord()
     * @uses VerifierQuestion::setVerifierQuestionAnswers()
     * @param int $questionId
     * @param int $sheetId
     * @param int $questionType
     * @param int $questionPosition
     * @param string $dataType
     * @param \StructType\Coord $questionCoord
     * @param \StructType\VerifierQuestionAnswerList $verifierQuestionAnswers
     */
    public function __construct($questionId = null, $sheetId = null, $questionType = null, $questionPosition = null, $dataType = null, \StructType\Coord $questionCoord = null, \StructType\VerifierQuestionAnswerList $verifierQuestionAnswers = null)
    {
        $this
            ->setQuestionId($questionId)
            ->setSheetId($sheetId)
            ->setQuestionType($questionType)
            ->setQuestionPosition($questionPosition)
            ->setDataType($dataType)
            ->setQuestionCoord($questionCoord)
            ->setVerifierQuestionAnswers($verifierQuestionAnswers);
    }
    /**
     * Get QuestionId value
     * @return int
     */
    public function getQuestionId()
    {
        return $this->QuestionId;
    }
    /**
     * Set QuestionId value
     * @param int $questionId
     * @return \StructType\VerifierQuestion
     */
    public function setQuestionId($questionId = null)
    {
        // validation for constraint: int
        if (!is_null($questionId) && !is_numeric($questionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($questionId)), __LINE__);
        }
        $this->QuestionId = $questionId;
        return $this;
    }
    /**
     * Get SheetId value
     * @return int
     */
    public function getSheetId()
    {
        return $this->SheetId;
    }
    /**
     * Set SheetId value
     * @param int $sheetId
     * @return \StructType\VerifierQuestion
     */
    public function setSheetId($sheetId = null)
    {
        // validation for constraint: int
        if (!is_null($sheetId) && !is_numeric($sheetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sheetId)), __LINE__);
        }
        $this->SheetId = $sheetId;
        return $this;
    }
    /**
     * Get QuestionType value
     * @return int
     */
    public function getQuestionType()
    {
        return $this->QuestionType;
    }
    /**
     * Set QuestionType value
     * @param int $questionType
     * @return \StructType\VerifierQuestion
     */
    public function setQuestionType($questionType = null)
    {
        // validation for constraint: int
        if (!is_null($questionType) && !is_numeric($questionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($questionType)), __LINE__);
        }
        $this->QuestionType = $questionType;
        return $this;
    }
    /**
     * Get QuestionPosition value
     * @return int
     */
    public function getQuestionPosition()
    {
        return $this->QuestionPosition;
    }
    /**
     * Set QuestionPosition value
     * @param int $questionPosition
     * @return \StructType\VerifierQuestion
     */
    public function setQuestionPosition($questionPosition = null)
    {
        // validation for constraint: int
        if (!is_null($questionPosition) && !is_numeric($questionPosition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($questionPosition)), __LINE__);
        }
        $this->QuestionPosition = $questionPosition;
        return $this;
    }
    /**
     * Get DataType value
     * @return string
     */
    public function getDataType()
    {
        return $this->DataType;
    }
    /**
     * Set DataType value
     * @param string $dataType
     * @return \StructType\VerifierQuestion
     */
    public function setDataType($dataType = null)
    {
        // validation for constraint: string
        if (!is_null($dataType) && !is_string($dataType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataType)), __LINE__);
        }
        $this->DataType = $dataType;
        return $this;
    }
    /**
     * Get QuestionCoord value
     * @return \StructType\Coord
     */
    public function getQuestionCoord()
    {
        return $this->QuestionCoord;
    }
    /**
     * Set QuestionCoord value
     * @param \StructType\Coord $questionCoord
     * @return \StructType\VerifierQuestion
     */
    public function setQuestionCoord(\StructType\Coord $questionCoord = null)
    {
        $this->QuestionCoord = $questionCoord;
        return $this;
    }
    /**
     * Get VerifierQuestionAnswers value
     * @return \StructType\VerifierQuestionAnswerList
     */
    public function getVerifierQuestionAnswers()
    {
        return $this->VerifierQuestionAnswers;
    }
    /**
     * Set VerifierQuestionAnswers value
     * @param \StructType\VerifierQuestionAnswerList $verifierQuestionAnswers
     * @return \StructType\VerifierQuestion
     */
    public function setVerifierQuestionAnswers(\StructType\VerifierQuestionAnswerList $verifierQuestionAnswers = null)
    {
        $this->VerifierQuestionAnswers = $verifierQuestionAnswers;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VerifierQuestion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
