<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerifierBatch StructType
 * @subpackage Structs
 */
class VerifierBatch extends AbstractStructBase
{
    /**
     * The BatchId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BatchId;
    /**
     * The PageCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageCount;
    /**
     * The NonFormsCount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NonFormsCount;
    /**
     * The UnlocatedAnswers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UnlocatedAnswers;
    /**
     * The Scanstation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Scanstation;
    /**
     * The VerifierSheets
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\VerifierSheetList
     */
    public $VerifierSheets;
    /**
     * Constructor method for VerifierBatch
     * @uses VerifierBatch::setBatchId()
     * @uses VerifierBatch::setPageCount()
     * @uses VerifierBatch::setNonFormsCount()
     * @uses VerifierBatch::setUnlocatedAnswers()
     * @uses VerifierBatch::setScanstation()
     * @uses VerifierBatch::setVerifierSheets()
     * @param int $batchId
     * @param int $pageCount
     * @param int $nonFormsCount
     * @param int $unlocatedAnswers
     * @param string $scanstation
     * @param \StructType\VerifierSheetList $verifierSheets
     */
    public function __construct($batchId = null, $pageCount = null, $nonFormsCount = null, $unlocatedAnswers = null, $scanstation = null, \StructType\VerifierSheetList $verifierSheets = null)
    {
        $this
            ->setBatchId($batchId)
            ->setPageCount($pageCount)
            ->setNonFormsCount($nonFormsCount)
            ->setUnlocatedAnswers($unlocatedAnswers)
            ->setScanstation($scanstation)
            ->setVerifierSheets($verifierSheets);
    }
    /**
     * Get BatchId value
     * @return int
     */
    public function getBatchId()
    {
        return $this->BatchId;
    }
    /**
     * Set BatchId value
     * @param int $batchId
     * @return \StructType\VerifierBatch
     */
    public function setBatchId($batchId = null)
    {
        // validation for constraint: int
        if (!is_null($batchId) && !is_numeric($batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($batchId)), __LINE__);
        }
        $this->BatchId = $batchId;
        return $this;
    }
    /**
     * Get PageCount value
     * @return int
     */
    public function getPageCount()
    {
        return $this->PageCount;
    }
    /**
     * Set PageCount value
     * @param int $pageCount
     * @return \StructType\VerifierBatch
     */
    public function setPageCount($pageCount = null)
    {
        // validation for constraint: int
        if (!is_null($pageCount) && !is_numeric($pageCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pageCount)), __LINE__);
        }
        $this->PageCount = $pageCount;
        return $this;
    }
    /**
     * Get NonFormsCount value
     * @return int
     */
    public function getNonFormsCount()
    {
        return $this->NonFormsCount;
    }
    /**
     * Set NonFormsCount value
     * @param int $nonFormsCount
     * @return \StructType\VerifierBatch
     */
    public function setNonFormsCount($nonFormsCount = null)
    {
        // validation for constraint: int
        if (!is_null($nonFormsCount) && !is_numeric($nonFormsCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nonFormsCount)), __LINE__);
        }
        $this->NonFormsCount = $nonFormsCount;
        return $this;
    }
    /**
     * Get UnlocatedAnswers value
     * @return int
     */
    public function getUnlocatedAnswers()
    {
        return $this->UnlocatedAnswers;
    }
    /**
     * Set UnlocatedAnswers value
     * @param int $unlocatedAnswers
     * @return \StructType\VerifierBatch
     */
    public function setUnlocatedAnswers($unlocatedAnswers = null)
    {
        // validation for constraint: int
        if (!is_null($unlocatedAnswers) && !is_numeric($unlocatedAnswers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unlocatedAnswers)), __LINE__);
        }
        $this->UnlocatedAnswers = $unlocatedAnswers;
        return $this;
    }
    /**
     * Get Scanstation value
     * @return string
     */
    public function getScanstation()
    {
        return $this->Scanstation;
    }
    /**
     * Set Scanstation value
     * @param string $scanstation
     * @return \StructType\VerifierBatch
     */
    public function setScanstation($scanstation = null)
    {
        // validation for constraint: string
        if (!is_null($scanstation) && !is_string($scanstation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scanstation)), __LINE__);
        }
        $this->Scanstation = $scanstation;
        return $this;
    }
    /**
     * Get VerifierSheets value
     * @return \StructType\VerifierSheetList
     */
    public function getVerifierSheets()
    {
        return $this->VerifierSheets;
    }
    /**
     * Set VerifierSheets value
     * @param \StructType\VerifierSheetList $verifierSheets
     * @return \StructType\VerifierBatch
     */
    public function setVerifierSheets(\StructType\VerifierSheetList $verifierSheets = null)
    {
        $this->VerifierSheets = $verifierSheets;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VerifierBatch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
