<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VFFormList StructType
 * @subpackage Structs
 */
class VFFormList extends AbstractStructBase
{
    /**
     * The VFForm
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VFForm[]
     */
    public $VFForm;
    /**
     * Constructor method for VFFormList
     * @uses VFFormList::setVFForm()
     * @param \StructType\VFForm[] $vFForm
     */
    public function __construct(array $vFForm = array())
    {
        $this
            ->setVFForm($vFForm);
    }
    /**
     * Get VFForm value
     * @return \StructType\VFForm[]|null
     */
    public function getVFForm()
    {
        return $this->VFForm;
    }
    /**
     * Set VFForm value
     * @throws \InvalidArgumentException
     * @param \StructType\VFForm[] $vFForm
     * @return \StructType\VFFormList
     */
    public function setVFForm(array $vFForm = array())
    {
        foreach ($vFForm as $vFFormListVFFormItem) {
            // validation for constraint: itemType
            if (!$vFFormListVFFormItem instanceof \StructType\VFForm) {
                throw new \InvalidArgumentException(sprintf('The VFForm property can only contain items of \StructType\VFForm, "%s" given', is_object($vFFormListVFFormItem) ? get_class($vFFormListVFFormItem) : gettype($vFFormListVFFormItem)), __LINE__);
            }
        }
        $this->VFForm = $vFForm;
        return $this;
    }
    /**
     * Add item to VFForm value
     * @throws \InvalidArgumentException
     * @param \StructType\VFForm $item
     * @return \StructType\VFFormList
     */
    public function addToVFForm(\StructType\VFForm $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VFForm) {
            throw new \InvalidArgumentException(sprintf('The VFForm property can only contain items of \StructType\VFForm, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VFForm[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VFFormList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
