<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserSessionInfo StructType
 * @subpackage Structs
 */
class UserSessionInfo extends AbstractStructBase
{
    /**
     * The UserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserId;
    /**
     * The UserType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserType;
    /**
     * The SubunitId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SubunitId;
    /**
     * The IsAdmin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAdmin;
    /**
     * The IsSubunitAdmin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSubunitAdmin;
    /**
     * The PenultimateLogin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PenultimateLogin;
    /**
     * The SessionStart
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SessionStart;
    /**
     * The SessionLastChange
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SessionLastChange;
    /**
     * The SessionRemainingSeconds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SessionRemainingSeconds;
    /**
     * Constructor method for UserSessionInfo
     * @uses UserSessionInfo::setUserId()
     * @uses UserSessionInfo::setUserType()
     * @uses UserSessionInfo::setSubunitId()
     * @uses UserSessionInfo::setIsAdmin()
     * @uses UserSessionInfo::setIsSubunitAdmin()
     * @uses UserSessionInfo::setPenultimateLogin()
     * @uses UserSessionInfo::setSessionStart()
     * @uses UserSessionInfo::setSessionLastChange()
     * @uses UserSessionInfo::setSessionRemainingSeconds()
     * @param int $userId
     * @param int $userType
     * @param int $subunitId
     * @param bool $isAdmin
     * @param bool $isSubunitAdmin
     * @param string $penultimateLogin
     * @param string $sessionStart
     * @param string $sessionLastChange
     * @param int $sessionRemainingSeconds
     */
    public function __construct($userId = null, $userType = null, $subunitId = null, $isAdmin = null, $isSubunitAdmin = null, $penultimateLogin = null, $sessionStart = null, $sessionLastChange = null, $sessionRemainingSeconds = null)
    {
        $this
            ->setUserId($userId)
            ->setUserType($userType)
            ->setSubunitId($subunitId)
            ->setIsAdmin($isAdmin)
            ->setIsSubunitAdmin($isSubunitAdmin)
            ->setPenultimateLogin($penultimateLogin)
            ->setSessionStart($sessionStart)
            ->setSessionLastChange($sessionLastChange)
            ->setSessionRemainingSeconds($sessionRemainingSeconds);
    }
    /**
     * Get UserId value
     * @return int
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param int $userId
     * @return \StructType\UserSessionInfo
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: int
        if (!is_null($userId) && !is_numeric($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userId)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
    /**
     * Get UserType value
     * @return int
     */
    public function getUserType()
    {
        return $this->UserType;
    }
    /**
     * Set UserType value
     * @param int $userType
     * @return \StructType\UserSessionInfo
     */
    public function setUserType($userType = null)
    {
        // validation for constraint: int
        if (!is_null($userType) && !is_numeric($userType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userType)), __LINE__);
        }
        $this->UserType = $userType;
        return $this;
    }
    /**
     * Get SubunitId value
     * @return int
     */
    public function getSubunitId()
    {
        return $this->SubunitId;
    }
    /**
     * Set SubunitId value
     * @param int $subunitId
     * @return \StructType\UserSessionInfo
     */
    public function setSubunitId($subunitId = null)
    {
        // validation for constraint: int
        if (!is_null($subunitId) && !is_numeric($subunitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($subunitId)), __LINE__);
        }
        $this->SubunitId = $subunitId;
        return $this;
    }
    /**
     * Get IsAdmin value
     * @return bool
     */
    public function getIsAdmin()
    {
        return $this->IsAdmin;
    }
    /**
     * Set IsAdmin value
     * @param bool $isAdmin
     * @return \StructType\UserSessionInfo
     */
    public function setIsAdmin($isAdmin = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAdmin) && !is_bool($isAdmin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAdmin)), __LINE__);
        }
        $this->IsAdmin = $isAdmin;
        return $this;
    }
    /**
     * Get IsSubunitAdmin value
     * @return bool
     */
    public function getIsSubunitAdmin()
    {
        return $this->IsSubunitAdmin;
    }
    /**
     * Set IsSubunitAdmin value
     * @param bool $isSubunitAdmin
     * @return \StructType\UserSessionInfo
     */
    public function setIsSubunitAdmin($isSubunitAdmin = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSubunitAdmin) && !is_bool($isSubunitAdmin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSubunitAdmin)), __LINE__);
        }
        $this->IsSubunitAdmin = $isSubunitAdmin;
        return $this;
    }
    /**
     * Get PenultimateLogin value
     * @return string
     */
    public function getPenultimateLogin()
    {
        return $this->PenultimateLogin;
    }
    /**
     * Set PenultimateLogin value
     * @param string $penultimateLogin
     * @return \StructType\UserSessionInfo
     */
    public function setPenultimateLogin($penultimateLogin = null)
    {
        // validation for constraint: string
        if (!is_null($penultimateLogin) && !is_string($penultimateLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($penultimateLogin)), __LINE__);
        }
        $this->PenultimateLogin = $penultimateLogin;
        return $this;
    }
    /**
     * Get SessionStart value
     * @return string
     */
    public function getSessionStart()
    {
        return $this->SessionStart;
    }
    /**
     * Set SessionStart value
     * @param string $sessionStart
     * @return \StructType\UserSessionInfo
     */
    public function setSessionStart($sessionStart = null)
    {
        // validation for constraint: string
        if (!is_null($sessionStart) && !is_string($sessionStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionStart)), __LINE__);
        }
        $this->SessionStart = $sessionStart;
        return $this;
    }
    /**
     * Get SessionLastChange value
     * @return string
     */
    public function getSessionLastChange()
    {
        return $this->SessionLastChange;
    }
    /**
     * Set SessionLastChange value
     * @param string $sessionLastChange
     * @return \StructType\UserSessionInfo
     */
    public function setSessionLastChange($sessionLastChange = null)
    {
        // validation for constraint: string
        if (!is_null($sessionLastChange) && !is_string($sessionLastChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionLastChange)), __LINE__);
        }
        $this->SessionLastChange = $sessionLastChange;
        return $this;
    }
    /**
     * Get SessionRemainingSeconds value
     * @return int
     */
    public function getSessionRemainingSeconds()
    {
        return $this->SessionRemainingSeconds;
    }
    /**
     * Set SessionRemainingSeconds value
     * @param int $sessionRemainingSeconds
     * @return \StructType\UserSessionInfo
     */
    public function setSessionRemainingSeconds($sessionRemainingSeconds = null)
    {
        // validation for constraint: int
        if (!is_null($sessionRemainingSeconds) && !is_numeric($sessionRemainingSeconds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sessionRemainingSeconds)), __LINE__);
        }
        $this->SessionRemainingSeconds = $sessionRemainingSeconds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserSessionInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
