<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserParams StructType
 * @subpackage Structs
 */
class UserParams extends AbstractStructBase
{
    /**
     * The UserIds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StringList
     */
    public $UserIds;
    /**
     * The Types
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StringList
     */
    public $Types;
    /**
     * The LoginName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LoginName;
    /**
     * The ExternalID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalID;
    /**
     * The Title
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The SurName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SurName;
    /**
     * The UnitName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UnitName;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The Subunits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StringList
     */
    public $Subunits;
    /**
     * The ActiveUsers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StringList
     */
    public $ActiveUsers;
    /**
     * The Limit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Limit;
    /**
     * The OrderBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderBy;
    /**
     * The OrderByDirection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderByDirection;
    /**
     * The ExtendedResponseAsJSON
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ExtendedResponseAsJSON;
    /**
     * Constructor method for UserParams
     * @uses UserParams::setUserIds()
     * @uses UserParams::setTypes()
     * @uses UserParams::setLoginName()
     * @uses UserParams::setExternalID()
     * @uses UserParams::setTitle()
     * @uses UserParams::setFirstName()
     * @uses UserParams::setSurName()
     * @uses UserParams::setUnitName()
     * @uses UserParams::setEmail()
     * @uses UserParams::setSubunits()
     * @uses UserParams::setActiveUsers()
     * @uses UserParams::setLimit()
     * @uses UserParams::setOrderBy()
     * @uses UserParams::setOrderByDirection()
     * @uses UserParams::setExtendedResponseAsJSON()
     * @param \StructType\StringList $userIds
     * @param \StructType\StringList $types
     * @param string $loginName
     * @param string $externalID
     * @param string $title
     * @param string $firstName
     * @param string $surName
     * @param string $unitName
     * @param string $email
     * @param \StructType\StringList $subunits
     * @param \StructType\StringList $activeUsers
     * @param int $limit
     * @param string $orderBy
     * @param string $orderByDirection
     * @param bool $extendedResponseAsJSON
     */
    public function __construct(\StructType\StringList $userIds = null, \StructType\StringList $types = null, $loginName = null, $externalID = null, $title = null, $firstName = null, $surName = null, $unitName = null, $email = null, \StructType\StringList $subunits = null, \StructType\StringList $activeUsers = null, $limit = null, $orderBy = null, $orderByDirection = null, $extendedResponseAsJSON = null)
    {
        $this
            ->setUserIds($userIds)
            ->setTypes($types)
            ->setLoginName($loginName)
            ->setExternalID($externalID)
            ->setTitle($title)
            ->setFirstName($firstName)
            ->setSurName($surName)
            ->setUnitName($unitName)
            ->setEmail($email)
            ->setSubunits($subunits)
            ->setActiveUsers($activeUsers)
            ->setLimit($limit)
            ->setOrderBy($orderBy)
            ->setOrderByDirection($orderByDirection)
            ->setExtendedResponseAsJSON($extendedResponseAsJSON);
    }
    /**
     * Get UserIds value
     * @return \StructType\StringList|null
     */
    public function getUserIds()
    {
        return $this->UserIds;
    }
    /**
     * Set UserIds value
     * @param \StructType\StringList $userIds
     * @return \StructType\UserParams
     */
    public function setUserIds(\StructType\StringList $userIds = null)
    {
        $this->UserIds = $userIds;
        return $this;
    }
    /**
     * Get Types value
     * @return \StructType\StringList|null
     */
    public function getTypes()
    {
        return $this->Types;
    }
    /**
     * Set Types value
     * @param \StructType\StringList $types
     * @return \StructType\UserParams
     */
    public function setTypes(\StructType\StringList $types = null)
    {
        $this->Types = $types;
        return $this;
    }
    /**
     * Get LoginName value
     * @return string|null
     */
    public function getLoginName()
    {
        return $this->LoginName;
    }
    /**
     * Set LoginName value
     * @param string $loginName
     * @return \StructType\UserParams
     */
    public function setLoginName($loginName = null)
    {
        // validation for constraint: string
        if (!is_null($loginName) && !is_string($loginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loginName)), __LINE__);
        }
        $this->LoginName = $loginName;
        return $this;
    }
    /**
     * Get ExternalID value
     * @return string|null
     */
    public function getExternalID()
    {
        return $this->ExternalID;
    }
    /**
     * Set ExternalID value
     * @param string $externalID
     * @return \StructType\UserParams
     */
    public function setExternalID($externalID = null)
    {
        // validation for constraint: string
        if (!is_null($externalID) && !is_string($externalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalID)), __LINE__);
        }
        $this->ExternalID = $externalID;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\UserParams
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\UserParams
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get SurName value
     * @return string|null
     */
    public function getSurName()
    {
        return $this->SurName;
    }
    /**
     * Set SurName value
     * @param string $surName
     * @return \StructType\UserParams
     */
    public function setSurName($surName = null)
    {
        // validation for constraint: string
        if (!is_null($surName) && !is_string($surName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surName)), __LINE__);
        }
        $this->SurName = $surName;
        return $this;
    }
    /**
     * Get UnitName value
     * @return string|null
     */
    public function getUnitName()
    {
        return $this->UnitName;
    }
    /**
     * Set UnitName value
     * @param string $unitName
     * @return \StructType\UserParams
     */
    public function setUnitName($unitName = null)
    {
        // validation for constraint: string
        if (!is_null($unitName) && !is_string($unitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitName)), __LINE__);
        }
        $this->UnitName = $unitName;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\UserParams
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get Subunits value
     * @return \StructType\StringList|null
     */
    public function getSubunits()
    {
        return $this->Subunits;
    }
    /**
     * Set Subunits value
     * @param \StructType\StringList $subunits
     * @return \StructType\UserParams
     */
    public function setSubunits(\StructType\StringList $subunits = null)
    {
        $this->Subunits = $subunits;
        return $this;
    }
    /**
     * Get ActiveUsers value
     * @return \StructType\StringList|null
     */
    public function getActiveUsers()
    {
        return $this->ActiveUsers;
    }
    /**
     * Set ActiveUsers value
     * @param \StructType\StringList $activeUsers
     * @return \StructType\UserParams
     */
    public function setActiveUsers(\StructType\StringList $activeUsers = null)
    {
        $this->ActiveUsers = $activeUsers;
        return $this;
    }
    /**
     * Get Limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->Limit;
    }
    /**
     * Set Limit value
     * @param int $limit
     * @return \StructType\UserParams
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->Limit = $limit;
        return $this;
    }
    /**
     * Get OrderBy value
     * @return string|null
     */
    public function getOrderBy()
    {
        return $this->OrderBy;
    }
    /**
     * Set OrderBy value
     * @param string $orderBy
     * @return \StructType\UserParams
     */
    public function setOrderBy($orderBy = null)
    {
        // validation for constraint: string
        if (!is_null($orderBy) && !is_string($orderBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderBy)), __LINE__);
        }
        $this->OrderBy = $orderBy;
        return $this;
    }
    /**
     * Get OrderByDirection value
     * @return string|null
     */
    public function getOrderByDirection()
    {
        return $this->OrderByDirection;
    }
    /**
     * Set OrderByDirection value
     * @param string $orderByDirection
     * @return \StructType\UserParams
     */
    public function setOrderByDirection($orderByDirection = null)
    {
        // validation for constraint: string
        if (!is_null($orderByDirection) && !is_string($orderByDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderByDirection)), __LINE__);
        }
        $this->OrderByDirection = $orderByDirection;
        return $this;
    }
    /**
     * Get ExtendedResponseAsJSON value
     * @return bool|null
     */
    public function getExtendedResponseAsJSON()
    {
        return $this->ExtendedResponseAsJSON;
    }
    /**
     * Set ExtendedResponseAsJSON value
     * @param bool $extendedResponseAsJSON
     * @return \StructType\UserParams
     */
    public function setExtendedResponseAsJSON($extendedResponseAsJSON = null)
    {
        // validation for constraint: boolean
        if (!is_null($extendedResponseAsJSON) && !is_bool($extendedResponseAsJSON)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($extendedResponseAsJSON)), __LINE__);
        }
        $this->ExtendedResponseAsJSON = $extendedResponseAsJSON;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserParams
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
