<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TextTemplate StructType
 * @subpackage Structs
 */
class TextTemplate extends AbstractStructBase
{
    /**
     * The Id
     * @var string
     */
    public $Id;
    /**
     * The SystemLanguage
     * @var string
     */
    public $SystemLanguage;
    /**
     * The SystemLanguageAbbreviation
     * @var string
     */
    public $SystemLanguageAbbreviation;
    /**
     * The Type
     * @var string
     */
    public $Type;
    /**
     * The FormSpecificText
     * @var bool
     */
    public $FormSpecificText;
    /**
     * The Subject
     * @var string
     */
    public $Subject;
    /**
     * The Text
     * @var string
     */
    public $Text;
    /**
     * Constructor method for TextTemplate
     * @uses TextTemplate::setId()
     * @uses TextTemplate::setSystemLanguage()
     * @uses TextTemplate::setSystemLanguageAbbreviation()
     * @uses TextTemplate::setType()
     * @uses TextTemplate::setFormSpecificText()
     * @uses TextTemplate::setSubject()
     * @uses TextTemplate::setText()
     * @param string $id
     * @param string $systemLanguage
     * @param string $systemLanguageAbbreviation
     * @param string $type
     * @param bool $formSpecificText
     * @param string $subject
     * @param string $text
     */
    public function __construct($id = null, $systemLanguage = null, $systemLanguageAbbreviation = null, $type = null, $formSpecificText = null, $subject = null, $text = null)
    {
        $this
            ->setId($id)
            ->setSystemLanguage($systemLanguage)
            ->setSystemLanguageAbbreviation($systemLanguageAbbreviation)
            ->setType($type)
            ->setFormSpecificText($formSpecificText)
            ->setSubject($subject)
            ->setText($text);
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\TextTemplate
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get SystemLanguage value
     * @return string|null
     */
    public function getSystemLanguage()
    {
        return $this->SystemLanguage;
    }
    /**
     * Set SystemLanguage value
     * @param string $systemLanguage
     * @return \StructType\TextTemplate
     */
    public function setSystemLanguage($systemLanguage = null)
    {
        // validation for constraint: string
        if (!is_null($systemLanguage) && !is_string($systemLanguage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($systemLanguage)), __LINE__);
        }
        $this->SystemLanguage = $systemLanguage;
        return $this;
    }
    /**
     * Get SystemLanguageAbbreviation value
     * @return string|null
     */
    public function getSystemLanguageAbbreviation()
    {
        return $this->SystemLanguageAbbreviation;
    }
    /**
     * Set SystemLanguageAbbreviation value
     * @param string $systemLanguageAbbreviation
     * @return \StructType\TextTemplate
     */
    public function setSystemLanguageAbbreviation($systemLanguageAbbreviation = null)
    {
        // validation for constraint: string
        if (!is_null($systemLanguageAbbreviation) && !is_string($systemLanguageAbbreviation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($systemLanguageAbbreviation)), __LINE__);
        }
        $this->SystemLanguageAbbreviation = $systemLanguageAbbreviation;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\TextTemplate
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get FormSpecificText value
     * @return bool|null
     */
    public function getFormSpecificText()
    {
        return $this->FormSpecificText;
    }
    /**
     * Set FormSpecificText value
     * @param bool $formSpecificText
     * @return \StructType\TextTemplate
     */
    public function setFormSpecificText($formSpecificText = null)
    {
        // validation for constraint: boolean
        if (!is_null($formSpecificText) && !is_bool($formSpecificText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($formSpecificText)), __LINE__);
        }
        $this->FormSpecificText = $formSpecificText;
        return $this;
    }
    /**
     * Get Subject value
     * @return string|null
     */
    public function getSubject()
    {
        return $this->Subject;
    }
    /**
     * Set Subject value
     * @param string $subject
     * @return \StructType\TextTemplate
     */
    public function setSubject($subject = null)
    {
        // validation for constraint: string
        if (!is_null($subject) && !is_string($subject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subject)), __LINE__);
        }
        $this->Subject = $subject;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \StructType\TextTemplate
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TextTemplate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
