<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SurveySummary StructType
 * @subpackage Structs
 */
class SurveySummary extends AbstractStructBase
{
    /**
     * The SurveyId
     * @var int
     */
    public $SurveyId;
    /**
     * The SurveyName
     * @var string
     */
    public $SurveyName;
    /**
     * The SurveyCourseCode
     * @var string
     */
    public $SurveyCourseCode;
    /**
     * The SubunitName
     * @var string
     */
    public $SubunitName;
    /**
     * The SurveyInstructorName
     * @var string
     */
    public $SurveyInstructorName;
    /**
     * The SurveyType
     * @var string
     */
    public $SurveyType;
    /**
     * The SurveyIsAnonymous
     * @var bool
     */
    public $SurveyIsAnonymous;
    /**
     * The SurveyStatus
     * @var int
     */
    public $SurveyStatus;
    /**
     * The SurveyOpenState
     * @var int
     */
    public $SurveyOpenState;
    /**
     * The SurveyPeriod
     * @var string
     */
    public $SurveyPeriod;
    /**
     * The SurveyCreationDate
     * @var string
     */
    public $SurveyCreationDate;
    /**
     * The SurveyScheduledStartDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SurveyScheduledStartDate;
    /**
     * The SurveyScheduledEndDate
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SurveyScheduledEndDate;
    /**
     * The DirectOnlineLink
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DirectOnlineLink;
    /**
     * The Participated
     * @var bool
     */
    public $Participated;
    /**
     * Constructor method for SurveySummary
     * @uses SurveySummary::setSurveyId()
     * @uses SurveySummary::setSurveyName()
     * @uses SurveySummary::setSurveyCourseCode()
     * @uses SurveySummary::setSubunitName()
     * @uses SurveySummary::setSurveyInstructorName()
     * @uses SurveySummary::setSurveyType()
     * @uses SurveySummary::setSurveyIsAnonymous()
     * @uses SurveySummary::setSurveyStatus()
     * @uses SurveySummary::setSurveyOpenState()
     * @uses SurveySummary::setSurveyPeriod()
     * @uses SurveySummary::setSurveyCreationDate()
     * @uses SurveySummary::setSurveyScheduledStartDate()
     * @uses SurveySummary::setSurveyScheduledEndDate()
     * @uses SurveySummary::setDirectOnlineLink()
     * @uses SurveySummary::setParticipated()
     * @param int $surveyId
     * @param string $surveyName
     * @param string $surveyCourseCode
     * @param string $subunitName
     * @param string $surveyInstructorName
     * @param string $surveyType
     * @param bool $surveyIsAnonymous
     * @param int $surveyStatus
     * @param int $surveyOpenState
     * @param string $surveyPeriod
     * @param string $surveyCreationDate
     * @param string $surveyScheduledStartDate
     * @param string $surveyScheduledEndDate
     * @param string $directOnlineLink
     * @param bool $participated
     */
    public function __construct($surveyId = null, $surveyName = null, $surveyCourseCode = null, $subunitName = null, $surveyInstructorName = null, $surveyType = null, $surveyIsAnonymous = null, $surveyStatus = null, $surveyOpenState = null, $surveyPeriod = null, $surveyCreationDate = null, $surveyScheduledStartDate = null, $surveyScheduledEndDate = null, $directOnlineLink = null, $participated = null)
    {
        $this
            ->setSurveyId($surveyId)
            ->setSurveyName($surveyName)
            ->setSurveyCourseCode($surveyCourseCode)
            ->setSubunitName($subunitName)
            ->setSurveyInstructorName($surveyInstructorName)
            ->setSurveyType($surveyType)
            ->setSurveyIsAnonymous($surveyIsAnonymous)
            ->setSurveyStatus($surveyStatus)
            ->setSurveyOpenState($surveyOpenState)
            ->setSurveyPeriod($surveyPeriod)
            ->setSurveyCreationDate($surveyCreationDate)
            ->setSurveyScheduledStartDate($surveyScheduledStartDate)
            ->setSurveyScheduledEndDate($surveyScheduledEndDate)
            ->setDirectOnlineLink($directOnlineLink)
            ->setParticipated($participated);
    }
    /**
     * Get SurveyId value
     * @return int|null
     */
    public function getSurveyId()
    {
        return $this->SurveyId;
    }
    /**
     * Set SurveyId value
     * @param int $surveyId
     * @return \StructType\SurveySummary
     */
    public function setSurveyId($surveyId = null)
    {
        // validation for constraint: int
        if (!is_null($surveyId) && !is_numeric($surveyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($surveyId)), __LINE__);
        }
        $this->SurveyId = $surveyId;
        return $this;
    }
    /**
     * Get SurveyName value
     * @return string|null
     */
    public function getSurveyName()
    {
        return $this->SurveyName;
    }
    /**
     * Set SurveyName value
     * @param string $surveyName
     * @return \StructType\SurveySummary
     */
    public function setSurveyName($surveyName = null)
    {
        // validation for constraint: string
        if (!is_null($surveyName) && !is_string($surveyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surveyName)), __LINE__);
        }
        $this->SurveyName = $surveyName;
        return $this;
    }
    /**
     * Get SurveyCourseCode value
     * @return string|null
     */
    public function getSurveyCourseCode()
    {
        return $this->SurveyCourseCode;
    }
    /**
     * Set SurveyCourseCode value
     * @param string $surveyCourseCode
     * @return \StructType\SurveySummary
     */
    public function setSurveyCourseCode($surveyCourseCode = null)
    {
        // validation for constraint: string
        if (!is_null($surveyCourseCode) && !is_string($surveyCourseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surveyCourseCode)), __LINE__);
        }
        $this->SurveyCourseCode = $surveyCourseCode;
        return $this;
    }
    /**
     * Get SubunitName value
     * @return string|null
     */
    public function getSubunitName()
    {
        return $this->SubunitName;
    }
    /**
     * Set SubunitName value
     * @param string $subunitName
     * @return \StructType\SurveySummary
     */
    public function setSubunitName($subunitName = null)
    {
        // validation for constraint: string
        if (!is_null($subunitName) && !is_string($subunitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subunitName)), __LINE__);
        }
        $this->SubunitName = $subunitName;
        return $this;
    }
    /**
     * Get SurveyInstructorName value
     * @return string|null
     */
    public function getSurveyInstructorName()
    {
        return $this->SurveyInstructorName;
    }
    /**
     * Set SurveyInstructorName value
     * @param string $surveyInstructorName
     * @return \StructType\SurveySummary
     */
    public function setSurveyInstructorName($surveyInstructorName = null)
    {
        // validation for constraint: string
        if (!is_null($surveyInstructorName) && !is_string($surveyInstructorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surveyInstructorName)), __LINE__);
        }
        $this->SurveyInstructorName = $surveyInstructorName;
        return $this;
    }
    /**
     * Get SurveyType value
     * @return string|null
     */
    public function getSurveyType()
    {
        return $this->SurveyType;
    }
    /**
     * Set SurveyType value
     * @param string $surveyType
     * @return \StructType\SurveySummary
     */
    public function setSurveyType($surveyType = null)
    {
        // validation for constraint: string
        if (!is_null($surveyType) && !is_string($surveyType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surveyType)), __LINE__);
        }
        $this->SurveyType = $surveyType;
        return $this;
    }
    /**
     * Get SurveyIsAnonymous value
     * @return bool|null
     */
    public function getSurveyIsAnonymous()
    {
        return $this->SurveyIsAnonymous;
    }
    /**
     * Set SurveyIsAnonymous value
     * @param bool $surveyIsAnonymous
     * @return \StructType\SurveySummary
     */
    public function setSurveyIsAnonymous($surveyIsAnonymous = null)
    {
        // validation for constraint: boolean
        if (!is_null($surveyIsAnonymous) && !is_bool($surveyIsAnonymous)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($surveyIsAnonymous)), __LINE__);
        }
        $this->SurveyIsAnonymous = $surveyIsAnonymous;
        return $this;
    }
    /**
     * Get SurveyStatus value
     * @return int|null
     */
    public function getSurveyStatus()
    {
        return $this->SurveyStatus;
    }
    /**
     * Set SurveyStatus value
     * @param int $surveyStatus
     * @return \StructType\SurveySummary
     */
    public function setSurveyStatus($surveyStatus = null)
    {
        // validation for constraint: int
        if (!is_null($surveyStatus) && !is_numeric($surveyStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($surveyStatus)), __LINE__);
        }
        $this->SurveyStatus = $surveyStatus;
        return $this;
    }
    /**
     * Get SurveyOpenState value
     * @return int|null
     */
    public function getSurveyOpenState()
    {
        return $this->SurveyOpenState;
    }
    /**
     * Set SurveyOpenState value
     * @param int $surveyOpenState
     * @return \StructType\SurveySummary
     */
    public function setSurveyOpenState($surveyOpenState = null)
    {
        // validation for constraint: int
        if (!is_null($surveyOpenState) && !is_numeric($surveyOpenState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($surveyOpenState)), __LINE__);
        }
        $this->SurveyOpenState = $surveyOpenState;
        return $this;
    }
    /**
     * Get SurveyPeriod value
     * @return string|null
     */
    public function getSurveyPeriod()
    {
        return $this->SurveyPeriod;
    }
    /**
     * Set SurveyPeriod value
     * @param string $surveyPeriod
     * @return \StructType\SurveySummary
     */
    public function setSurveyPeriod($surveyPeriod = null)
    {
        // validation for constraint: string
        if (!is_null($surveyPeriod) && !is_string($surveyPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surveyPeriod)), __LINE__);
        }
        $this->SurveyPeriod = $surveyPeriod;
        return $this;
    }
    /**
     * Get SurveyCreationDate value
     * @return string|null
     */
    public function getSurveyCreationDate()
    {
        return $this->SurveyCreationDate;
    }
    /**
     * Set SurveyCreationDate value
     * @param string $surveyCreationDate
     * @return \StructType\SurveySummary
     */
    public function setSurveyCreationDate($surveyCreationDate = null)
    {
        // validation for constraint: string
        if (!is_null($surveyCreationDate) && !is_string($surveyCreationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surveyCreationDate)), __LINE__);
        }
        $this->SurveyCreationDate = $surveyCreationDate;
        return $this;
    }
    /**
     * Get SurveyScheduledStartDate value
     * @return string|null
     */
    public function getSurveyScheduledStartDate()
    {
        return $this->SurveyScheduledStartDate;
    }
    /**
     * Set SurveyScheduledStartDate value
     * @param string $surveyScheduledStartDate
     * @return \StructType\SurveySummary
     */
    public function setSurveyScheduledStartDate($surveyScheduledStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($surveyScheduledStartDate) && !is_string($surveyScheduledStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surveyScheduledStartDate)), __LINE__);
        }
        $this->SurveyScheduledStartDate = $surveyScheduledStartDate;
        return $this;
    }
    /**
     * Get SurveyScheduledEndDate value
     * @return string|null
     */
    public function getSurveyScheduledEndDate()
    {
        return $this->SurveyScheduledEndDate;
    }
    /**
     * Set SurveyScheduledEndDate value
     * @param string $surveyScheduledEndDate
     * @return \StructType\SurveySummary
     */
    public function setSurveyScheduledEndDate($surveyScheduledEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($surveyScheduledEndDate) && !is_string($surveyScheduledEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($surveyScheduledEndDate)), __LINE__);
        }
        $this->SurveyScheduledEndDate = $surveyScheduledEndDate;
        return $this;
    }
    /**
     * Get DirectOnlineLink value
     * @return string|null
     */
    public function getDirectOnlineLink()
    {
        return $this->DirectOnlineLink;
    }
    /**
     * Set DirectOnlineLink value
     * @param string $directOnlineLink
     * @return \StructType\SurveySummary
     */
    public function setDirectOnlineLink($directOnlineLink = null)
    {
        // validation for constraint: string
        if (!is_null($directOnlineLink) && !is_string($directOnlineLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directOnlineLink)), __LINE__);
        }
        $this->DirectOnlineLink = $directOnlineLink;
        return $this;
    }
    /**
     * Get Participated value
     * @return bool|null
     */
    public function getParticipated()
    {
        return $this->Participated;
    }
    /**
     * Set Participated value
     * @param bool $participated
     * @return \StructType\SurveySummary
     */
    public function setParticipated($participated = null)
    {
        // validation for constraint: boolean
        if (!is_null($participated) && !is_bool($participated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($participated)), __LINE__);
        }
        $this->Participated = $participated;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SurveySummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
