<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SurveyParams StructType
 * @subpackage Structs
 */
class SurveyParams extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The Subunits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StringList
     */
    public $Subunits;
    /**
     * The Instructors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StringList
     */
    public $Instructors;
    /**
     * The Periods
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StringList
     */
    public $Periods;
    /**
     * The Forms
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StringList
     */
    public $Forms;
    /**
     * The CourseTypes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StringList
     */
    public $CourseTypes;
    /**
     * The Courses
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StringList
     */
    public $Courses;
    /**
     * The ProgramOfStudies
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StringList
     */
    public $ProgramOfStudies;
    /**
     * The Statuses
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StringList
     */
    public $Statuses;
    /**
     * The Types
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StringList
     */
    public $Types;
    /**
     * The OpenState
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $OpenState;
    /**
     * The Limit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Limit;
    /**
     * The OrderBy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderBy;
    /**
     * The OrderByDirection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderByDirection;
    /**
     * The ExtendedResponseAsJSON
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ExtendedResponseAsJSON;
    /**
     * The CreationDateFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreationDateFrom;
    /**
     * The CreationDateTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreationDateTo;
    /**
     * The LastChangeDateFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastChangeDateFrom;
    /**
     * The LastChangeDateTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastChangeDateTo;
    /**
     * Constructor method for SurveyParams
     * @uses SurveyParams::setName()
     * @uses SurveyParams::setSubunits()
     * @uses SurveyParams::setInstructors()
     * @uses SurveyParams::setPeriods()
     * @uses SurveyParams::setForms()
     * @uses SurveyParams::setCourseTypes()
     * @uses SurveyParams::setCourses()
     * @uses SurveyParams::setProgramOfStudies()
     * @uses SurveyParams::setStatuses()
     * @uses SurveyParams::setTypes()
     * @uses SurveyParams::setOpenState()
     * @uses SurveyParams::setLimit()
     * @uses SurveyParams::setOrderBy()
     * @uses SurveyParams::setOrderByDirection()
     * @uses SurveyParams::setExtendedResponseAsJSON()
     * @uses SurveyParams::setCreationDateFrom()
     * @uses SurveyParams::setCreationDateTo()
     * @uses SurveyParams::setLastChangeDateFrom()
     * @uses SurveyParams::setLastChangeDateTo()
     * @param string $name
     * @param \StructType\StringList $subunits
     * @param \StructType\StringList $instructors
     * @param \StructType\StringList $periods
     * @param \StructType\StringList $forms
     * @param \StructType\StringList $courseTypes
     * @param \StructType\StringList $courses
     * @param \StructType\StringList $programOfStudies
     * @param \StructType\StringList $statuses
     * @param \StructType\StringList $types
     * @param int $openState
     * @param int $limit
     * @param string $orderBy
     * @param string $orderByDirection
     * @param bool $extendedResponseAsJSON
     * @param string $creationDateFrom
     * @param string $creationDateTo
     * @param string $lastChangeDateFrom
     * @param string $lastChangeDateTo
     */
    public function __construct($name = null, \StructType\StringList $subunits = null, \StructType\StringList $instructors = null, \StructType\StringList $periods = null, \StructType\StringList $forms = null, \StructType\StringList $courseTypes = null, \StructType\StringList $courses = null, \StructType\StringList $programOfStudies = null, \StructType\StringList $statuses = null, \StructType\StringList $types = null, $openState = null, $limit = null, $orderBy = null, $orderByDirection = null, $extendedResponseAsJSON = null, $creationDateFrom = null, $creationDateTo = null, $lastChangeDateFrom = null, $lastChangeDateTo = null)
    {
        $this
            ->setName($name)
            ->setSubunits($subunits)
            ->setInstructors($instructors)
            ->setPeriods($periods)
            ->setForms($forms)
            ->setCourseTypes($courseTypes)
            ->setCourses($courses)
            ->setProgramOfStudies($programOfStudies)
            ->setStatuses($statuses)
            ->setTypes($types)
            ->setOpenState($openState)
            ->setLimit($limit)
            ->setOrderBy($orderBy)
            ->setOrderByDirection($orderByDirection)
            ->setExtendedResponseAsJSON($extendedResponseAsJSON)
            ->setCreationDateFrom($creationDateFrom)
            ->setCreationDateTo($creationDateTo)
            ->setLastChangeDateFrom($lastChangeDateFrom)
            ->setLastChangeDateTo($lastChangeDateTo);
    }
    /**
     * Get Name value
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\SurveyParams
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Subunits value
     * @return \StructType\StringList|null
     */
    public function getSubunits()
    {
        return $this->Subunits;
    }
    /**
     * Set Subunits value
     * @param \StructType\StringList $subunits
     * @return \StructType\SurveyParams
     */
    public function setSubunits(\StructType\StringList $subunits = null)
    {
        $this->Subunits = $subunits;
        return $this;
    }
    /**
     * Get Instructors value
     * @return \StructType\StringList|null
     */
    public function getInstructors()
    {
        return $this->Instructors;
    }
    /**
     * Set Instructors value
     * @param \StructType\StringList $instructors
     * @return \StructType\SurveyParams
     */
    public function setInstructors(\StructType\StringList $instructors = null)
    {
        $this->Instructors = $instructors;
        return $this;
    }
    /**
     * Get Periods value
     * @return \StructType\StringList|null
     */
    public function getPeriods()
    {
        return $this->Periods;
    }
    /**
     * Set Periods value
     * @param \StructType\StringList $periods
     * @return \StructType\SurveyParams
     */
    public function setPeriods(\StructType\StringList $periods = null)
    {
        $this->Periods = $periods;
        return $this;
    }
    /**
     * Get Forms value
     * @return \StructType\StringList|null
     */
    public function getForms()
    {
        return $this->Forms;
    }
    /**
     * Set Forms value
     * @param \StructType\StringList $forms
     * @return \StructType\SurveyParams
     */
    public function setForms(\StructType\StringList $forms = null)
    {
        $this->Forms = $forms;
        return $this;
    }
    /**
     * Get CourseTypes value
     * @return \StructType\StringList|null
     */
    public function getCourseTypes()
    {
        return $this->CourseTypes;
    }
    /**
     * Set CourseTypes value
     * @param \StructType\StringList $courseTypes
     * @return \StructType\SurveyParams
     */
    public function setCourseTypes(\StructType\StringList $courseTypes = null)
    {
        $this->CourseTypes = $courseTypes;
        return $this;
    }
    /**
     * Get Courses value
     * @return \StructType\StringList|null
     */
    public function getCourses()
    {
        return $this->Courses;
    }
    /**
     * Set Courses value
     * @param \StructType\StringList $courses
     * @return \StructType\SurveyParams
     */
    public function setCourses(\StructType\StringList $courses = null)
    {
        $this->Courses = $courses;
        return $this;
    }
    /**
     * Get ProgramOfStudies value
     * @return \StructType\StringList|null
     */
    public function getProgramOfStudies()
    {
        return $this->ProgramOfStudies;
    }
    /**
     * Set ProgramOfStudies value
     * @param \StructType\StringList $programOfStudies
     * @return \StructType\SurveyParams
     */
    public function setProgramOfStudies(\StructType\StringList $programOfStudies = null)
    {
        $this->ProgramOfStudies = $programOfStudies;
        return $this;
    }
    /**
     * Get Statuses value
     * @return \StructType\StringList|null
     */
    public function getStatuses()
    {
        return $this->Statuses;
    }
    /**
     * Set Statuses value
     * @param \StructType\StringList $statuses
     * @return \StructType\SurveyParams
     */
    public function setStatuses(\StructType\StringList $statuses = null)
    {
        $this->Statuses = $statuses;
        return $this;
    }
    /**
     * Get Types value
     * @return \StructType\StringList|null
     */
    public function getTypes()
    {
        return $this->Types;
    }
    /**
     * Set Types value
     * @param \StructType\StringList $types
     * @return \StructType\SurveyParams
     */
    public function setTypes(\StructType\StringList $types = null)
    {
        $this->Types = $types;
        return $this;
    }
    /**
     * Get OpenState value
     * @return int|null
     */
    public function getOpenState()
    {
        return $this->OpenState;
    }
    /**
     * Set OpenState value
     * @param int $openState
     * @return \StructType\SurveyParams
     */
    public function setOpenState($openState = null)
    {
        // validation for constraint: int
        if (!is_null($openState) && !is_numeric($openState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($openState)), __LINE__);
        }
        $this->OpenState = $openState;
        return $this;
    }
    /**
     * Get Limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->Limit;
    }
    /**
     * Set Limit value
     * @param int $limit
     * @return \StructType\SurveyParams
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->Limit = $limit;
        return $this;
    }
    /**
     * Get OrderBy value
     * @return string|null
     */
    public function getOrderBy()
    {
        return $this->OrderBy;
    }
    /**
     * Set OrderBy value
     * @param string $orderBy
     * @return \StructType\SurveyParams
     */
    public function setOrderBy($orderBy = null)
    {
        // validation for constraint: string
        if (!is_null($orderBy) && !is_string($orderBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderBy)), __LINE__);
        }
        $this->OrderBy = $orderBy;
        return $this;
    }
    /**
     * Get OrderByDirection value
     * @return string|null
     */
    public function getOrderByDirection()
    {
        return $this->OrderByDirection;
    }
    /**
     * Set OrderByDirection value
     * @param string $orderByDirection
     * @return \StructType\SurveyParams
     */
    public function setOrderByDirection($orderByDirection = null)
    {
        // validation for constraint: string
        if (!is_null($orderByDirection) && !is_string($orderByDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderByDirection)), __LINE__);
        }
        $this->OrderByDirection = $orderByDirection;
        return $this;
    }
    /**
     * Get ExtendedResponseAsJSON value
     * @return bool|null
     */
    public function getExtendedResponseAsJSON()
    {
        return $this->ExtendedResponseAsJSON;
    }
    /**
     * Set ExtendedResponseAsJSON value
     * @param bool $extendedResponseAsJSON
     * @return \StructType\SurveyParams
     */
    public function setExtendedResponseAsJSON($extendedResponseAsJSON = null)
    {
        // validation for constraint: boolean
        if (!is_null($extendedResponseAsJSON) && !is_bool($extendedResponseAsJSON)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($extendedResponseAsJSON)), __LINE__);
        }
        $this->ExtendedResponseAsJSON = $extendedResponseAsJSON;
        return $this;
    }
    /**
     * Get CreationDateFrom value
     * @return string|null
     */
    public function getCreationDateFrom()
    {
        return $this->CreationDateFrom;
    }
    /**
     * Set CreationDateFrom value
     * @param string $creationDateFrom
     * @return \StructType\SurveyParams
     */
    public function setCreationDateFrom($creationDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateFrom) && !is_string($creationDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creationDateFrom)), __LINE__);
        }
        $this->CreationDateFrom = $creationDateFrom;
        return $this;
    }
    /**
     * Get CreationDateTo value
     * @return string|null
     */
    public function getCreationDateTo()
    {
        return $this->CreationDateTo;
    }
    /**
     * Set CreationDateTo value
     * @param string $creationDateTo
     * @return \StructType\SurveyParams
     */
    public function setCreationDateTo($creationDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTo) && !is_string($creationDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($creationDateTo)), __LINE__);
        }
        $this->CreationDateTo = $creationDateTo;
        return $this;
    }
    /**
     * Get LastChangeDateFrom value
     * @return string|null
     */
    public function getLastChangeDateFrom()
    {
        return $this->LastChangeDateFrom;
    }
    /**
     * Set LastChangeDateFrom value
     * @param string $lastChangeDateFrom
     * @return \StructType\SurveyParams
     */
    public function setLastChangeDateFrom($lastChangeDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($lastChangeDateFrom) && !is_string($lastChangeDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastChangeDateFrom)), __LINE__);
        }
        $this->LastChangeDateFrom = $lastChangeDateFrom;
        return $this;
    }
    /**
     * Get LastChangeDateTo value
     * @return string|null
     */
    public function getLastChangeDateTo()
    {
        return $this->LastChangeDateTo;
    }
    /**
     * Set LastChangeDateTo value
     * @param string $lastChangeDateTo
     * @return \StructType\SurveyParams
     */
    public function setLastChangeDateTo($lastChangeDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($lastChangeDateTo) && !is_string($lastChangeDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastChangeDateTo)), __LINE__);
        }
        $this->LastChangeDateTo = $lastChangeDateTo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SurveyParams
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
