<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReaderScanBatchParams StructType
 * @subpackage Structs
 */
class ReaderScanBatchParams extends AbstractStructBase
{
    /**
     * The SurveyIds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StringList
     */
    public $SurveyIds;
    /**
     * The BatchIds
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StringList
     */
    public $BatchIds;
    /**
     * The DateTimeStart
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateTimeStart;
    /**
     * The DateTimeEnd
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateTimeEnd;
    /**
     * Constructor method for ReaderScanBatchParams
     * @uses ReaderScanBatchParams::setSurveyIds()
     * @uses ReaderScanBatchParams::setBatchIds()
     * @uses ReaderScanBatchParams::setDateTimeStart()
     * @uses ReaderScanBatchParams::setDateTimeEnd()
     * @param \StructType\StringList $surveyIds
     * @param \StructType\StringList $batchIds
     * @param string $dateTimeStart
     * @param string $dateTimeEnd
     */
    public function __construct(\StructType\StringList $surveyIds = null, \StructType\StringList $batchIds = null, $dateTimeStart = null, $dateTimeEnd = null)
    {
        $this
            ->setSurveyIds($surveyIds)
            ->setBatchIds($batchIds)
            ->setDateTimeStart($dateTimeStart)
            ->setDateTimeEnd($dateTimeEnd);
    }
    /**
     * Get SurveyIds value
     * @return \StructType\StringList|null
     */
    public function getSurveyIds()
    {
        return $this->SurveyIds;
    }
    /**
     * Set SurveyIds value
     * @param \StructType\StringList $surveyIds
     * @return \StructType\ReaderScanBatchParams
     */
    public function setSurveyIds(\StructType\StringList $surveyIds = null)
    {
        $this->SurveyIds = $surveyIds;
        return $this;
    }
    /**
     * Get BatchIds value
     * @return \StructType\StringList|null
     */
    public function getBatchIds()
    {
        return $this->BatchIds;
    }
    /**
     * Set BatchIds value
     * @param \StructType\StringList $batchIds
     * @return \StructType\ReaderScanBatchParams
     */
    public function setBatchIds(\StructType\StringList $batchIds = null)
    {
        $this->BatchIds = $batchIds;
        return $this;
    }
    /**
     * Get DateTimeStart value
     * @return string|null
     */
    public function getDateTimeStart()
    {
        return $this->DateTimeStart;
    }
    /**
     * Set DateTimeStart value
     * @param string $dateTimeStart
     * @return \StructType\ReaderScanBatchParams
     */
    public function setDateTimeStart($dateTimeStart = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeStart) && !is_string($dateTimeStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateTimeStart)), __LINE__);
        }
        $this->DateTimeStart = $dateTimeStart;
        return $this;
    }
    /**
     * Get DateTimeEnd value
     * @return string|null
     */
    public function getDateTimeEnd()
    {
        return $this->DateTimeEnd;
    }
    /**
     * Set DateTimeEnd value
     * @param string $dateTimeEnd
     * @return \StructType\ReaderScanBatchParams
     */
    public function setDateTimeEnd($dateTimeEnd = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeEnd) && !is_string($dateTimeEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateTimeEnd)), __LINE__);
        }
        $this->DateTimeEnd = $dateTimeEnd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReaderScanBatchParams
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
