<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PwsdSummary StructType
 * @subpackage Structs
 */
class PwsdSummary extends AbstractStructBase
{
    /**
     * The SurveyId
     * @var int
     */
    public $SurveyId;
    /**
     * The Participated
     * @var bool
     */
    public $Participated;
    /**
     * The Person
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\Person
     */
    public $Person;
    /**
     * Constructor method for PwsdSummary
     * @uses PwsdSummary::setSurveyId()
     * @uses PwsdSummary::setParticipated()
     * @uses PwsdSummary::setPerson()
     * @param int $surveyId
     * @param bool $participated
     * @param \StructType\Person $person
     */
    public function __construct($surveyId = null, $participated = null, \StructType\Person $person = null)
    {
        $this
            ->setSurveyId($surveyId)
            ->setParticipated($participated)
            ->setPerson($person);
    }
    /**
     * Get SurveyId value
     * @return int|null
     */
    public function getSurveyId()
    {
        return $this->SurveyId;
    }
    /**
     * Set SurveyId value
     * @param int $surveyId
     * @return \StructType\PwsdSummary
     */
    public function setSurveyId($surveyId = null)
    {
        // validation for constraint: int
        if (!is_null($surveyId) && !is_numeric($surveyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($surveyId)), __LINE__);
        }
        $this->SurveyId = $surveyId;
        return $this;
    }
    /**
     * Get Participated value
     * @return bool|null
     */
    public function getParticipated()
    {
        return $this->Participated;
    }
    /**
     * Set Participated value
     * @param bool $participated
     * @return \StructType\PwsdSummary
     */
    public function setParticipated($participated = null)
    {
        // validation for constraint: boolean
        if (!is_null($participated) && !is_bool($participated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($participated)), __LINE__);
        }
        $this->Participated = $participated;
        return $this;
    }
    /**
     * Get Person value
     * @return \StructType\Person|null
     */
    public function getPerson()
    {
        return $this->Person;
    }
    /**
     * Set Person value
     * @param \StructType\Person $person
     * @return \StructType\PwsdSummary
     */
    public function setPerson(\StructType\Person $person = null)
    {
        $this->Person = $person;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PwsdSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
