<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PDFReportDefinition StructType
 * @subpackage Structs
 */
class PDFReportDefinition extends AbstractStructBase
{
    /**
     * The ReportDefinitionId
     * @var int
     */
    public $ReportDefinitionId;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Description
     * @var string
     */
    public $Description;
    /**
     * The BaseFormId
     * @var int
     */
    public $BaseFormId;
    /**
     * The Questions
     * @var \StructType\IDList
     */
    public $Questions;
    /**
     * The Recipients
     * @var \StructType\IDList
     */
    public $Recipients;
    /**
     * The BaseReportId
     * @var int
     */
    public $BaseReportId;
    /**
     * The SubgroupQuestion
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $SubgroupQuestion;
    /**
     * The SubgroupShowOverallReport
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $SubgroupShowOverallReport;
    /**
     * The SubgroupShowDivider
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $SubgroupShowDivider;
    /**
     * The SubgroupIncludeOpenQuestions
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $SubgroupIncludeOpenQuestions;
    /**
     * Constructor method for PDFReportDefinition
     * @uses PDFReportDefinition::setReportDefinitionId()
     * @uses PDFReportDefinition::setName()
     * @uses PDFReportDefinition::setDescription()
     * @uses PDFReportDefinition::setBaseFormId()
     * @uses PDFReportDefinition::setQuestions()
     * @uses PDFReportDefinition::setRecipients()
     * @uses PDFReportDefinition::setBaseReportId()
     * @uses PDFReportDefinition::setSubgroupQuestion()
     * @uses PDFReportDefinition::setSubgroupShowOverallReport()
     * @uses PDFReportDefinition::setSubgroupShowDivider()
     * @uses PDFReportDefinition::setSubgroupIncludeOpenQuestions()
     * @param int $reportDefinitionId
     * @param string $name
     * @param string $description
     * @param int $baseFormId
     * @param \StructType\IDList $questions
     * @param \StructType\IDList $recipients
     * @param int $baseReportId
     * @param int $subgroupQuestion
     * @param bool $subgroupShowOverallReport
     * @param bool $subgroupShowDivider
     * @param bool $subgroupIncludeOpenQuestions
     */
    public function __construct($reportDefinitionId = null, $name = null, $description = null, $baseFormId = null, \StructType\IDList $questions = null, \StructType\IDList $recipients = null, $baseReportId = null, $subgroupQuestion = null, $subgroupShowOverallReport = null, $subgroupShowDivider = null, $subgroupIncludeOpenQuestions = null)
    {
        $this
            ->setReportDefinitionId($reportDefinitionId)
            ->setName($name)
            ->setDescription($description)
            ->setBaseFormId($baseFormId)
            ->setQuestions($questions)
            ->setRecipients($recipients)
            ->setBaseReportId($baseReportId)
            ->setSubgroupQuestion($subgroupQuestion)
            ->setSubgroupShowOverallReport($subgroupShowOverallReport)
            ->setSubgroupShowDivider($subgroupShowDivider)
            ->setSubgroupIncludeOpenQuestions($subgroupIncludeOpenQuestions);
    }
    /**
     * Get ReportDefinitionId value
     * @return int|null
     */
    public function getReportDefinitionId()
    {
        return $this->ReportDefinitionId;
    }
    /**
     * Set ReportDefinitionId value
     * @param int $reportDefinitionId
     * @return \StructType\PDFReportDefinition
     */
    public function setReportDefinitionId($reportDefinitionId = null)
    {
        // validation for constraint: int
        if (!is_null($reportDefinitionId) && !is_numeric($reportDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reportDefinitionId)), __LINE__);
        }
        $this->ReportDefinitionId = $reportDefinitionId;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\PDFReportDefinition
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\PDFReportDefinition
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get BaseFormId value
     * @return int|null
     */
    public function getBaseFormId()
    {
        return $this->BaseFormId;
    }
    /**
     * Set BaseFormId value
     * @param int $baseFormId
     * @return \StructType\PDFReportDefinition
     */
    public function setBaseFormId($baseFormId = null)
    {
        // validation for constraint: int
        if (!is_null($baseFormId) && !is_numeric($baseFormId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($baseFormId)), __LINE__);
        }
        $this->BaseFormId = $baseFormId;
        return $this;
    }
    /**
     * Get Questions value
     * @return \StructType\IDList|null
     */
    public function getQuestions()
    {
        return $this->Questions;
    }
    /**
     * Set Questions value
     * @param \StructType\IDList $questions
     * @return \StructType\PDFReportDefinition
     */
    public function setQuestions(\StructType\IDList $questions = null)
    {
        $this->Questions = $questions;
        return $this;
    }
    /**
     * Get Recipients value
     * @return \StructType\IDList|null
     */
    public function getRecipients()
    {
        return $this->Recipients;
    }
    /**
     * Set Recipients value
     * @param \StructType\IDList $recipients
     * @return \StructType\PDFReportDefinition
     */
    public function setRecipients(\StructType\IDList $recipients = null)
    {
        $this->Recipients = $recipients;
        return $this;
    }
    /**
     * Get BaseReportId value
     * @return int|null
     */
    public function getBaseReportId()
    {
        return $this->BaseReportId;
    }
    /**
     * Set BaseReportId value
     * @param int $baseReportId
     * @return \StructType\PDFReportDefinition
     */
    public function setBaseReportId($baseReportId = null)
    {
        // validation for constraint: int
        if (!is_null($baseReportId) && !is_numeric($baseReportId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($baseReportId)), __LINE__);
        }
        $this->BaseReportId = $baseReportId;
        return $this;
    }
    /**
     * Get SubgroupQuestion value
     * @return int|null
     */
    public function getSubgroupQuestion()
    {
        return $this->SubgroupQuestion;
    }
    /**
     * Set SubgroupQuestion value
     * @param int $subgroupQuestion
     * @return \StructType\PDFReportDefinition
     */
    public function setSubgroupQuestion($subgroupQuestion = null)
    {
        // validation for constraint: int
        if (!is_null($subgroupQuestion) && !is_numeric($subgroupQuestion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($subgroupQuestion)), __LINE__);
        }
        $this->SubgroupQuestion = $subgroupQuestion;
        return $this;
    }
    /**
     * Get SubgroupShowOverallReport value
     * @return bool|null
     */
    public function getSubgroupShowOverallReport()
    {
        return $this->SubgroupShowOverallReport;
    }
    /**
     * Set SubgroupShowOverallReport value
     * @param bool $subgroupShowOverallReport
     * @return \StructType\PDFReportDefinition
     */
    public function setSubgroupShowOverallReport($subgroupShowOverallReport = null)
    {
        // validation for constraint: boolean
        if (!is_null($subgroupShowOverallReport) && !is_bool($subgroupShowOverallReport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($subgroupShowOverallReport)), __LINE__);
        }
        $this->SubgroupShowOverallReport = $subgroupShowOverallReport;
        return $this;
    }
    /**
     * Get SubgroupShowDivider value
     * @return bool|null
     */
    public function getSubgroupShowDivider()
    {
        return $this->SubgroupShowDivider;
    }
    /**
     * Set SubgroupShowDivider value
     * @param bool $subgroupShowDivider
     * @return \StructType\PDFReportDefinition
     */
    public function setSubgroupShowDivider($subgroupShowDivider = null)
    {
        // validation for constraint: boolean
        if (!is_null($subgroupShowDivider) && !is_bool($subgroupShowDivider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($subgroupShowDivider)), __LINE__);
        }
        $this->SubgroupShowDivider = $subgroupShowDivider;
        return $this;
    }
    /**
     * Get SubgroupIncludeOpenQuestions value
     * @return bool|null
     */
    public function getSubgroupIncludeOpenQuestions()
    {
        return $this->SubgroupIncludeOpenQuestions;
    }
    /**
     * Set SubgroupIncludeOpenQuestions value
     * @param bool $subgroupIncludeOpenQuestions
     * @return \StructType\PDFReportDefinition
     */
    public function setSubgroupIncludeOpenQuestions($subgroupIncludeOpenQuestions = null)
    {
        // validation for constraint: boolean
        if (!is_null($subgroupIncludeOpenQuestions) && !is_bool($subgroupIncludeOpenQuestions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($subgroupIncludeOpenQuestions)), __LINE__);
        }
        $this->SubgroupIncludeOpenQuestions = $subgroupIncludeOpenQuestions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PDFReportDefinition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
