<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PDFPlugin StructType
 * @subpackage Structs
 */
class PDFPlugin extends AbstractStructBase
{
    /**
     * The PluginId
     * @var int
     */
    public $PluginId;
    /**
     * The Title
     * @var string
     */
    public $Title;
    /**
     * The ClassName
     * @var string
     */
    public $ClassName;
    /**
     * The IsDefault
     * @var bool
     */
    public $IsDefault;
    /**
     * The IsCustomPlugin
     * @var bool
     */
    public $IsCustomPlugin;
    /**
     * The ReportType
     * @var int
     */
    public $ReportType;
    /**
     * The Owner
     * @var int
     */
    public $Owner;
    /**
     * The Path
     * @var string
     */
    public $Path;
    /**
     * Constructor method for PDFPlugin
     * @uses PDFPlugin::setPluginId()
     * @uses PDFPlugin::setTitle()
     * @uses PDFPlugin::setClassName()
     * @uses PDFPlugin::setIsDefault()
     * @uses PDFPlugin::setIsCustomPlugin()
     * @uses PDFPlugin::setReportType()
     * @uses PDFPlugin::setOwner()
     * @uses PDFPlugin::setPath()
     * @param int $pluginId
     * @param string $title
     * @param string $className
     * @param bool $isDefault
     * @param bool $isCustomPlugin
     * @param int $reportType
     * @param int $owner
     * @param string $path
     */
    public function __construct($pluginId = null, $title = null, $className = null, $isDefault = null, $isCustomPlugin = null, $reportType = null, $owner = null, $path = null)
    {
        $this
            ->setPluginId($pluginId)
            ->setTitle($title)
            ->setClassName($className)
            ->setIsDefault($isDefault)
            ->setIsCustomPlugin($isCustomPlugin)
            ->setReportType($reportType)
            ->setOwner($owner)
            ->setPath($path);
    }
    /**
     * Get PluginId value
     * @return int|null
     */
    public function getPluginId()
    {
        return $this->PluginId;
    }
    /**
     * Set PluginId value
     * @param int $pluginId
     * @return \StructType\PDFPlugin
     */
    public function setPluginId($pluginId = null)
    {
        // validation for constraint: int
        if (!is_null($pluginId) && !is_numeric($pluginId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pluginId)), __LINE__);
        }
        $this->PluginId = $pluginId;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\PDFPlugin
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get ClassName value
     * @return string|null
     */
    public function getClassName()
    {
        return $this->ClassName;
    }
    /**
     * Set ClassName value
     * @param string $className
     * @return \StructType\PDFPlugin
     */
    public function setClassName($className = null)
    {
        // validation for constraint: string
        if (!is_null($className) && !is_string($className)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($className)), __LINE__);
        }
        $this->ClassName = $className;
        return $this;
    }
    /**
     * Get IsDefault value
     * @return bool|null
     */
    public function getIsDefault()
    {
        return $this->IsDefault;
    }
    /**
     * Set IsDefault value
     * @param bool $isDefault
     * @return \StructType\PDFPlugin
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDefault)), __LINE__);
        }
        $this->IsDefault = $isDefault;
        return $this;
    }
    /**
     * Get IsCustomPlugin value
     * @return bool|null
     */
    public function getIsCustomPlugin()
    {
        return $this->IsCustomPlugin;
    }
    /**
     * Set IsCustomPlugin value
     * @param bool $isCustomPlugin
     * @return \StructType\PDFPlugin
     */
    public function setIsCustomPlugin($isCustomPlugin = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCustomPlugin) && !is_bool($isCustomPlugin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCustomPlugin)), __LINE__);
        }
        $this->IsCustomPlugin = $isCustomPlugin;
        return $this;
    }
    /**
     * Get ReportType value
     * @return int|null
     */
    public function getReportType()
    {
        return $this->ReportType;
    }
    /**
     * Set ReportType value
     * @param int $reportType
     * @return \StructType\PDFPlugin
     */
    public function setReportType($reportType = null)
    {
        // validation for constraint: int
        if (!is_null($reportType) && !is_numeric($reportType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reportType)), __LINE__);
        }
        $this->ReportType = $reportType;
        return $this;
    }
    /**
     * Get Owner value
     * @return int|null
     */
    public function getOwner()
    {
        return $this->Owner;
    }
    /**
     * Set Owner value
     * @param int $owner
     * @return \StructType\PDFPlugin
     */
    public function setOwner($owner = null)
    {
        // validation for constraint: int
        if (!is_null($owner) && !is_numeric($owner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($owner)), __LINE__);
        }
        $this->Owner = $owner;
        return $this;
    }
    /**
     * Get Path value
     * @return string|null
     */
    public function getPath()
    {
        return $this->Path;
    }
    /**
     * Set Path value
     * @param string $path
     * @return \StructType\PDFPlugin
     */
    public function setPath($path = null)
    {
        // validation for constraint: string
        if (!is_null($path) && !is_string($path)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($path)), __LINE__);
        }
        $this->Path = $path;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PDFPlugin
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
