<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NoticeList StructType
 * @subpackage Structs
 */
class NoticeList extends AbstractStructBase
{
    /**
     * The Notice
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Notice[]
     */
    public $Notice;
    /**
     * Constructor method for NoticeList
     * @uses NoticeList::setNotice()
     * @param \StructType\Notice[] $notice
     */
    public function __construct(array $notice = array())
    {
        $this
            ->setNotice($notice);
    }
    /**
     * Get Notice value
     * @return \StructType\Notice[]|null
     */
    public function getNotice()
    {
        return $this->Notice;
    }
    /**
     * Set Notice value
     * @throws \InvalidArgumentException
     * @param \StructType\Notice[] $notice
     * @return \StructType\NoticeList
     */
    public function setNotice(array $notice = array())
    {
        foreach ($notice as $noticeListNoticeItem) {
            // validation for constraint: itemType
            if (!$noticeListNoticeItem instanceof \StructType\Notice) {
                throw new \InvalidArgumentException(sprintf('The Notice property can only contain items of \StructType\Notice, "%s" given', is_object($noticeListNoticeItem) ? get_class($noticeListNoticeItem) : gettype($noticeListNoticeItem)), __LINE__);
            }
        }
        $this->Notice = $notice;
        return $this;
    }
    /**
     * Add item to Notice value
     * @throws \InvalidArgumentException
     * @param \StructType\Notice $item
     * @return \StructType\NoticeList
     */
    public function addToNotice(\StructType\Notice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Notice) {
            throw new \InvalidArgumentException(sprintf('The Notice property can only contain items of \StructType\Notice, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Notice[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NoticeList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
